/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOperationsResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListOperationsResponse.Builder, ListOperationsResponse> {
    private static final SdkField<List<OperationSummary>> OPERATIONS_FIELD = SdkField
            .<List<OperationSummary>> builder(MarshallingType.LIST)
            .memberName("Operations")
            .getter(getter(ListOperationsResponse::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOperationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<OperationSummary> operations;

    private final String nextToken;

    private ListOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Operations property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the operations that match the specified criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information about the operations that match the specified criteria.
     */
    public final List<OperationSummary> operations() {
        return operations;
    }

    /**
     * <p>
     * If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the
     * next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
     * request.
     * </p>
     * <note>
     * <p>
     * AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's
     * possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but
     * that subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.
     * </p>
     * </note>
     * 
     * @return If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to
     *         get the next group of results. Specify the value of <code>NextToken</code> from the previous response in
     *         the next request.</p> <note>
     *         <p>
     *         AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified
     *         criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the
     *         specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations
     *         that match the criteria.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOperations() ? operations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse) obj;
        return hasOperations() == other.hasOperations() && Objects.equals(operations(), other.operations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOperationsResponse").add("Operations", hasOperations() ? operations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operations":
            return Optional.ofNullable(clazz.cast(operations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsResponse, T> g) {
        return obj -> g.apply((ListOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOperationsResponse> {
        /**
         * <p>
         * Summary information about the operations that match the specified criteria.
         * </p>
         * 
         * @param operations
         *        Summary information about the operations that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<OperationSummary> operations);

        /**
         * <p>
         * Summary information about the operations that match the specified criteria.
         * </p>
         * 
         * @param operations
         *        Summary information about the operations that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(OperationSummary... operations);

        /**
         * <p>
         * Summary information about the operations that match the specified criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OperationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<OperationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OperationSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #operations(List<OperationSummary>)}.
         * 
         * @param operations
         *        a consumer that will call methods on {@link List<OperationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(List<OperationSummary>)
         */
        Builder operations(Consumer<OperationSummary.Builder>... operations);

        /**
         * <p>
         * If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get
         * the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
         * request.
         * </p>
         * <note>
         * <p>
         * AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria.
         * It's possible that no operations in the first <code>MaxResults</code> operations matched the specified
         * criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations that match
         * the criteria.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to
         *        get the next group of results. Specify the value of <code>NextToken</code> from the previous response
         *        in the next request.</p> <note>
         *        <p>
         *        AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified
         *        criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the
         *        specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain
         *        operations that match the criteria.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<OperationSummary> operations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            super(model);
            operations(model.operations);
            nextToken(model.nextToken);
        }

        public final Collection<OperationSummary.Builder> getOperations() {
            if (operations instanceof SdkAutoConstructList) {
                return null;
            }
            return operations != null ? operations.stream().map(OperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(OperationSummary... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<OperationSummary.Builder>... operations) {
            operations(Stream.of(operations).map(c -> OperationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<OperationSummary.BuilderImpl> operations) {
            this.operations = OperationSummaryListCopier.copyFromBuilder(operations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
