/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstancesRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<ListInstancesRequest.Builder, ListInstancesRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(ListInstancesRequest::serviceId)).setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String serviceId;

    private final String nextToken;

    private final Integer maxResults;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the service that you want to list instances for.
     * </p>
     * 
     * @return The ID of the service that you want to list instances for.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * For the first <code>ListInstances</code> request, omit this value.
     * </p>
     * <p>
     * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     * <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
     * from the previous response in the next request.
     * </p>
     * 
     * @return For the first <code>ListInstances</code> request, omit this value.</p>
     *         <p>
     *         If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     *         <code>ListInstances</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of instances that you want AWS Cloud Map to return in the response to a
     * <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud Map
     * returns up to 100 instances.
     * </p>
     * 
     * @return The maximum number of instances that you want AWS Cloud Map to return in the response to a
     *         <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud
     *         Map returns up to 100 instances.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstancesRequest").add("ServiceId", serviceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesRequest, T> g) {
        return obj -> g.apply((ListInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInstancesRequest> {
        /**
         * <p>
         * The ID of the service that you want to list instances for.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service that you want to list instances for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * For the first <code>ListInstances</code> request, omit this value.
         * </p>
         * <p>
         * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         * <code>ListInstances</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        For the first <code>ListInstances</code> request, omit this value.</p>
         *        <p>
         *        If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         *        <code>ListInstances</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of instances that you want AWS Cloud Map to return in the response to a
         * <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud Map
         * returns up to 100 instances.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of instances that you want AWS Cloud Map to return in the response to a
         *        <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, AWS
         *        Cloud Map returns up to 100 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String serviceId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            super(model);
            serviceId(model.serviceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
