/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OperationType {
    CREATE_NAMESPACE("CREATE_NAMESPACE"),
    DELETE_NAMESPACE("DELETE_NAMESPACE"),
    UPDATE_NAMESPACE("UPDATE_NAMESPACE"),
    UPDATE_SERVICE("UPDATE_SERVICE"),
    REGISTER_INSTANCE("REGISTER_INSTANCE"),
    DEREGISTER_INSTANCE("DEREGISTER_INSTANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OperationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationType> knownValues() {
        return Stream.of(OperationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

