/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HealthStatusFilter {
    HEALTHY("HEALTHY"),
    UNHEALTHY("UNHEALTHY"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HealthStatusFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthStatusFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HealthStatusFilter.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthStatusFilter> knownValues() {
        return Stream.of(HealthStatusFilter.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

