/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NamespaceType {
    DNS_PUBLIC("DNS_PUBLIC"),
    DNS_PRIVATE("DNS_PRIVATE"),
    HTTP("HTTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NamespaceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NamespaceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NamespaceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NamespaceType> knownValues() {
        return Stream.of(NamespaceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

