/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecord;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsConfigChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsConfigChange> {
    private static final SdkField<List<DnsRecord>> DNS_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsRecords").getter(DnsConfigChange.getter(DnsConfigChange::dnsRecords)).setter(DnsConfigChange.setter(Builder::dnsRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DnsRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_RECORDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DnsRecord> dnsRecords;

    private DnsConfigChange(BuilderImpl builder) {
        this.dnsRecords = builder.dnsRecords;
    }

    public boolean hasDnsRecords() {
        return this.dnsRecords != null && !(this.dnsRecords instanceof SdkAutoConstructList);
    }

    public List<DnsRecord> dnsRecords() {
        return this.dnsRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfigChange)) {
            return false;
        }
        DnsConfigChange other = (DnsConfigChange)obj;
        return Objects.equals(this.dnsRecords(), other.dnsRecords());
    }

    public String toString() {
        return ToString.builder((String)"DnsConfigChange").add("DnsRecords", this.dnsRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsRecords": {
                return Optional.ofNullable(clazz.cast(this.dnsRecords()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsConfigChange, T> g) {
        return obj -> g.apply((DnsConfigChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DnsRecord> dnsRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DnsConfigChange model) {
            this.dnsRecords(model.dnsRecords);
        }

        public final Collection<DnsRecord.Builder> getDnsRecords() {
            return this.dnsRecords != null ? (Collection)this.dnsRecords.stream().map(DnsRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsRecords(Collection<DnsRecord> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copy(dnsRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(DnsRecord ... dnsRecords) {
            this.dnsRecords(Arrays.asList(dnsRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(Consumer<DnsRecord.Builder> ... dnsRecords) {
            this.dnsRecords(Stream.of(dnsRecords).map(c -> (DnsRecord)((DnsRecord.Builder)DnsRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDnsRecords(Collection<DnsRecord.BuilderImpl> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copyFromBuilder(dnsRecords);
        }

        public DnsConfigChange build() {
            return new DnsConfigChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsConfigChange> {
        public Builder dnsRecords(Collection<DnsRecord> var1);

        public Builder dnsRecords(DnsRecord ... var1);

        public Builder dnsRecords(Consumer<DnsRecord.Builder> ... var1);
    }
}

