/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DnsRecordMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Long> TTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TTL").isBinary(false).build();
    private static final DnsRecordMarshaller INSTANCE = new DnsRecordMarshaller();

    private DnsRecordMarshaller() {
    }

    public static DnsRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DnsRecord dnsRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dnsRecord, (String)"dnsRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dnsRecord.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dnsRecord.ttl(), TTL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

