/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfig;
import software.amazon.awssdk.services.servicediscovery.transform.DnsRecordUnmarshaller;

public class DnsConfigUnmarshaller
implements Unmarshaller<DnsConfig, JsonUnmarshallerContext> {
    private static final DnsConfigUnmarshaller INSTANCE = new DnsConfigUnmarshaller();

    public DnsConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        DnsConfig.Builder dnsConfigBuilder = DnsConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NamespaceId", targetDepth)) {
                    context.nextToken();
                    dnsConfigBuilder.namespaceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DnsRecords", targetDepth)) {
                    context.nextToken();
                    dnsConfigBuilder.dnsRecords(new ListUnmarshaller((Unmarshaller)DnsRecordUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DnsConfig)dnsConfigBuilder.build();
    }

    public static DnsConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

