/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange;

@SdkInternalApi
public class DnsConfigChangeMarshaller {
    private static final MarshallingInfo<List> DNSRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsRecords").build();
    private static final DnsConfigChangeMarshaller INSTANCE = new DnsConfigChangeMarshaller();

    public static DnsConfigChangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DnsConfigChange dnsConfigChange, ProtocolMarshaller protocolMarshaller) {
        if (dnsConfigChange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dnsConfigChange.dnsRecords(), DNSRECORDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

