/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;

public final class GetInstancesHealthStatusPaginator
implements SdkIterable<GetInstancesHealthStatusResponse> {
    private final ServiceDiscoveryClient client;
    private final GetInstancesHealthStatusRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetInstancesHealthStatusPaginator(ServiceDiscoveryClient client, GetInstancesHealthStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetInstancesHealthStatusResponseFetcher();
    }

    public Iterator<GetInstancesHealthStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetInstancesHealthStatusResponseFetcher
    implements NextPageFetcher<GetInstancesHealthStatusResponse> {
        private GetInstancesHealthStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetInstancesHealthStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetInstancesHealthStatusResponse nextPage(GetInstancesHealthStatusResponse previousPage) {
            if (previousPage == null) {
                return GetInstancesHealthStatusPaginator.this.client.getInstancesHealthStatus(GetInstancesHealthStatusPaginator.this.firstRequest);
            }
            return GetInstancesHealthStatusPaginator.this.client.getInstancesHealthStatus((GetInstancesHealthStatusRequest)((Object)GetInstancesHealthStatusPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

