/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.servicediscovery.model.OperationStatus;
import software.amazon.awssdk.services.servicediscovery.model.OperationTargetType;
import software.amazon.awssdk.services.servicediscovery.model.OperationTargetsMapCopier;
import software.amazon.awssdk.services.servicediscovery.model.OperationType;
import software.amazon.awssdk.services.servicediscovery.transform.OperationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Operation
implements StructuredPojo,
ToCopyableBuilder<Builder, Operation> {
    private final String id;
    private final String type;
    private final String status;
    private final String errorMessage;
    private final String errorCode;
    private final Instant createDate;
    private final Instant updateDate;
    private final Map<String, String> targets;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.createDate = builder.createDate;
        this.updateDate = builder.updateDate;
        this.targets = builder.targets;
    }

    public String id() {
        return this.id;
    }

    public OperationType type() {
        return OperationType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Map<OperationTargetType, String> targets() {
        return TypeConverter.convert(this.targets, OperationTargetType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)OperationTargetType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> targetsStrings() {
        return this.targets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.updateDate(), other.updateDate()) && Objects.equals(this.targetsStrings(), other.targetsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Operation").add("Id", (Object)this.id()).add("Type", (Object)this.typeString()).add("Status", (Object)this.statusString()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCode()).add("CreateDate", (Object)this.createDate()).add("UpdateDate", (Object)this.updateDate()).add("Targets", this.targetsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCode()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "UpdateDate": {
                return Optional.of(clazz.cast(this.updateDate()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targetsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String status;
        private String errorMessage;
        private String errorCode;
        private Instant createDate;
        private Instant updateDate;
        private Map<String, String> targets;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            this.id(model.id);
            this.type(model.type);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.createDate(model.createDate);
            this.updateDate(model.updateDate);
            this.targets(model.targets);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Map<String, String> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Map<String, String> targets) {
            this.targets = OperationTargetsMapCopier.copy(targets);
            return this;
        }

        public final void setTargets(Map<String, String> targets) {
            this.targets = OperationTargetsMapCopier.copy(targets);
        }

        public Operation build() {
            return new Operation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Operation> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(OperationType var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder createDate(Instant var1);

        public Builder updateDate(Instant var1);

        public Builder targets(Map<String, String> var1);
    }
}

