/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DuplicateRequestException;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.InstanceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.InvalidInputException;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.OperationNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.paginators.GetInstancesHealthStatusPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListInstancesPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListServicesPaginator;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePrivateDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePrivateDnsNamespaceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePublicDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePublicDnsNamespaceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreateServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreateServiceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteNamespaceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteServiceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeregisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeregisterInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstancesHealthStatusRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstancesHealthStatusResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetNamespaceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetOperationResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetServiceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListNamespacesResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListOperationsRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListOperationsResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListServicesResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.RegisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.RegisterInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateServiceResponseUnmarshaller;

@SdkInternalApi
final class DefaultServiceDiscoveryClient
implements ServiceDiscoveryClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultServiceDiscoveryClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "servicediscovery";
    }

    @Override
    public CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePrivateDnsNamespaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreatePrivateDnsNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPrivateDnsNamespaceRequest).withMarshaller((Marshaller)new CreatePrivateDnsNamespaceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePublicDnsNamespaceResponse createPublicDnsNamespace(CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePublicDnsNamespaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreatePublicDnsNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPublicDnsNamespaceRequest).withMarshaller((Marshaller)new CreatePublicDnsNamespaceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws InvalidInputException, ResourceLimitExceededException, NamespaceNotFoundException, ServiceAlreadyExistsException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateServiceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServiceRequest).withMarshaller((Marshaller)new CreateServiceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNamespaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNamespaceRequest).withMarshaller((Marshaller)new DeleteNamespaceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws InvalidInputException, ServiceNotFoundException, ResourceInUseException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteServiceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServiceRequest).withMarshaller((Marshaller)new DeleteServiceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeregisterInstanceResponse deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterInstanceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeregisterInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterInstanceRequest).withMarshaller((Marshaller)new DeregisterInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInstanceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInstanceRequest).withMarshaller((Marshaller)new GetInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetInstancesHealthStatusResponse getInstancesHealthStatus(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInstancesHealthStatusResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetInstancesHealthStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInstancesHealthStatusRequest).withMarshaller((Marshaller)new GetInstancesHealthStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetInstancesHealthStatusPaginator getInstancesHealthStatusIterable(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return new GetInstancesHealthStatusPaginator(this, getInstancesHealthStatusRequest);
    }

    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNamespaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNamespaceRequest).withMarshaller((Marshaller)new GetNamespaceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws OperationNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOperationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getOperationRequest).withMarshaller((Marshaller)new GetOperationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetServiceResponse getService(GetServiceRequest getServiceRequest) throws InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceRequest).withMarshaller((Marshaller)new GetServiceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInstancesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInstancesRequest).withMarshaller((Marshaller)new ListInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListInstancesPaginator listInstancesIterable(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return new ListInstancesPaginator(this, listInstancesRequest);
    }

    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNamespacesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListNamespacesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNamespacesRequest).withMarshaller((Marshaller)new ListNamespacesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListNamespacesPaginator listNamespacesIterable(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return new ListNamespacesPaginator(this, listNamespacesRequest);
    }

    @Override
    public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOperationsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOperationsRequest).withMarshaller((Marshaller)new ListOperationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListOperationsPaginator listOperationsIterable(ListOperationsRequest listOperationsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return new ListOperationsPaginator(this, listOperationsRequest);
    }

    @Override
    public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServicesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServicesRequest).withMarshaller((Marshaller)new ListServicesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListServicesPaginator listServicesIterable(ListServicesRequest listServicesRequest) throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return new ListServicesPaginator(this, listServicesRequest);
    }

    @Override
    public RegisterInstanceResponse registerInstance(RegisterInstanceRequest registerInstanceRequest) throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterInstanceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RegisterInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerInstanceRequest).withMarshaller((Marshaller)new RegisterInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws DuplicateRequestException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServiceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceRequest).withMarshaller((Marshaller)new UpdateServiceRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(ServiceDiscoveryException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotFound").withModeledClass(OperationNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUse").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInput").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceAlreadyExists").withModeledClass(ServiceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceNotFound").withModeledClass(ServiceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NamespaceAlreadyExists").withModeledClass(NamespaceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InstanceNotFound").withModeledClass(InstanceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NamespaceNotFound").withModeledClass(NamespaceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceeded").withModeledClass(ResourceLimitExceededException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

