/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;

public class ListNamespacesIterable
implements SdkIterable<ListNamespacesResponse> {
    private final ServiceDiscoveryClient client;
    private final ListNamespacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNamespacesIterable(ServiceDiscoveryClient client, ListNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNamespacesResponseFetcher();
    }

    public Iterator<ListNamespacesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListNamespacesIterable resume(ListNamespacesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListNamespacesIterable(this.client, (ListNamespacesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListNamespacesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListNamespacesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListNamespacesResponseFetcher
    implements SyncPageFetcher<ListNamespacesResponse> {
        private ListNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamespacesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListNamespacesResponse nextPage(ListNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListNamespacesIterable.this.client.listNamespaces(ListNamespacesIterable.this.firstRequest);
            }
            return ListNamespacesIterable.this.client.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

