/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;

public class GetInstancesHealthStatusIterable
implements SdkIterable<GetInstancesHealthStatusResponse> {
    private final ServiceDiscoveryClient client;
    private final GetInstancesHealthStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInstancesHealthStatusIterable(ServiceDiscoveryClient client, GetInstancesHealthStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetInstancesHealthStatusResponseFetcher();
    }

    public Iterator<GetInstancesHealthStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetInstancesHealthStatusIterable resume(GetInstancesHealthStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetInstancesHealthStatusIterable(this.client, (GetInstancesHealthStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetInstancesHealthStatusIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetInstancesHealthStatusResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetInstancesHealthStatusResponseFetcher
    implements SyncPageFetcher<GetInstancesHealthStatusResponse> {
        private GetInstancesHealthStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetInstancesHealthStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetInstancesHealthStatusResponse nextPage(GetInstancesHealthStatusResponse previousPage) {
            if (previousPage == null) {
                return GetInstancesHealthStatusIterable.this.client.getInstancesHealthStatus(GetInstancesHealthStatusIterable.this.firstRequest);
            }
            return GetInstancesHealthStatusIterable.this.client.getInstancesHealthStatus((GetInstancesHealthStatusRequest)((Object)GetInstancesHealthStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

