/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.servicediscovery.model.OperationSummary;
import software.amazon.awssdk.services.servicediscovery.model.OperationSummaryListCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOperationsResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, ListOperationsResponse> {
    private final List<OperationSummary> operations;
    private final String nextToken;

    private ListOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextToken = builder.nextToken;
    }

    public List<OperationSummary> operations() {
        return this.operations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse)((Object)obj);
        return Objects.equals(this.operations(), other.operations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListOperationsResponse").add("Operations", this.operations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operations": {
                return Optional.of(clazz.cast(this.operations()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<OperationSummary> operations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            super(model);
            this.operations(model.operations);
            this.nextToken(model.nextToken);
        }

        public final Collection<OperationSummary.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(OperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(OperationSummary ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<OperationSummary.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (OperationSummary)((OperationSummary.Builder)OperationSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<OperationSummary.BuilderImpl> operations) {
            this.operations = OperationSummaryListCopier.copyFromBuilder(operations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    CopyableBuilder<Builder, ListOperationsResponse> {
        public Builder operations(Collection<OperationSummary> var1);

        public Builder operations(OperationSummary ... var1);

        public Builder operations(Consumer<OperationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

