/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicediscovery.model.OperationFilter;
import software.amazon.awssdk.services.servicediscovery.model.OperationFiltersCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOperationsRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, ListOperationsRequest> {
    private final String nextToken;
    private final Integer maxResults;
    private final List<OperationFilter> filters;

    private ListOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public List<OperationFilter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsRequest)) {
            return false;
        }
        ListOperationsRequest other = (ListOperationsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filters(), other.filters());
    }

    public String toString() {
        return ToString.builder((String)"ListOperationsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filters", this.filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<OperationFilter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filters(model.filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<OperationFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(OperationFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<OperationFilter> filters) {
            this.filters = OperationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OperationFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OperationFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (OperationFilter)((OperationFilter.Builder)OperationFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<OperationFilter.BuilderImpl> filters) {
            this.filters = OperationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListOperationsRequest build() {
            return new ListOperationsRequest(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    CopyableBuilder<Builder, ListOperationsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filters(Collection<OperationFilter> var1);

        public Builder filters(OperationFilter ... var1);

        public Builder filters(Consumer<OperationFilter.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

