/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecord;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecordListCopier;
import software.amazon.awssdk.services.servicediscovery.transform.DnsConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DnsConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, DnsConfig> {
    private final String namespaceId;
    private final List<DnsRecord> dnsRecords;

    private DnsConfig(BuilderImpl builder) {
        this.namespaceId = builder.namespaceId;
        this.dnsRecords = builder.dnsRecords;
    }

    public String namespaceId() {
        return this.namespaceId;
    }

    public List<DnsRecord> dnsRecords() {
        return this.dnsRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfig)) {
            return false;
        }
        DnsConfig other = (DnsConfig)obj;
        return Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.dnsRecords(), other.dnsRecords());
    }

    public String toString() {
        return ToString.builder((String)"DnsConfig").add("NamespaceId", (Object)this.namespaceId()).add("DnsRecords", this.dnsRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamespaceId": {
                return Optional.of(clazz.cast(this.namespaceId()));
            }
            case "DnsRecords": {
                return Optional.of(clazz.cast(this.dnsRecords()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespaceId;
        private List<DnsRecord> dnsRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsConfig model) {
            this.namespaceId(model.namespaceId);
            this.dnsRecords(model.dnsRecords);
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        public final Collection<DnsRecord.Builder> getDnsRecords() {
            return this.dnsRecords != null ? (Collection)this.dnsRecords.stream().map(DnsRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsRecords(Collection<DnsRecord> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copy(dnsRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(DnsRecord ... dnsRecords) {
            this.dnsRecords(Arrays.asList(dnsRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(Consumer<DnsRecord.Builder> ... dnsRecords) {
            this.dnsRecords(Stream.of(dnsRecords).map(c -> (DnsRecord)((DnsRecord.Builder)DnsRecord.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDnsRecords(Collection<DnsRecord.BuilderImpl> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copyFromBuilder(dnsRecords);
        }

        public DnsConfig build() {
            return new DnsConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DnsConfig> {
        public Builder namespaceId(String var1);

        public Builder dnsRecords(Collection<DnsRecord> var1);

        public Builder dnsRecords(DnsRecord ... var1);

        public Builder dnsRecords(Consumer<DnsRecord.Builder> ... var1);
    }
}

