/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ApplicationTagStatus;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourcesListCopier;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourcesListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationTagResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationTagResult> {
    private static final SdkField<String> APPLICATION_TAG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationTagStatus").getter(ApplicationTagResult.getter(ApplicationTagResult::applicationTagStatusAsString)).setter(ApplicationTagResult.setter(Builder::applicationTagStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationTagStatus").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(ApplicationTagResult.getter(ApplicationTagResult::errorMessage)).setter(ApplicationTagResult.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<List<ResourcesListItem>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(ApplicationTagResult.getter(ApplicationTagResult::resources)).setter(ApplicationTagResult.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ApplicationTagResult.getter(ApplicationTagResult::nextToken)).setter(ApplicationTagResult.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_TAG_STATUS_FIELD, ERROR_MESSAGE_FIELD, RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationTagStatus;
    private final String errorMessage;
    private final List<ResourcesListItem> resources;
    private final String nextToken;

    private ApplicationTagResult(BuilderImpl builder) {
        this.applicationTagStatus = builder.applicationTagStatus;
        this.errorMessage = builder.errorMessage;
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
    }

    public final ApplicationTagStatus applicationTagStatus() {
        return ApplicationTagStatus.fromValue(this.applicationTagStatus);
    }

    public final String applicationTagStatusAsString() {
        return this.applicationTagStatus;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ResourcesListItem> resources() {
        return this.resources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTagStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationTagResult)) {
            return false;
        }
        ApplicationTagResult other = (ApplicationTagResult)obj;
        return Objects.equals(this.applicationTagStatusAsString(), other.applicationTagStatusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationTagResult").add("ApplicationTagStatus", (Object)this.applicationTagStatusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("Resources", this.hasResources() ? this.resources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationTagStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationTagStatusAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationTagResult, T> g) {
        return obj -> g.apply((ApplicationTagResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationTagStatus;
        private String errorMessage;
        private List<ResourcesListItem> resources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationTagResult model) {
            this.applicationTagStatus(model.applicationTagStatus);
            this.errorMessage(model.errorMessage);
            this.resources(model.resources);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationTagStatus() {
            return this.applicationTagStatus;
        }

        public final void setApplicationTagStatus(String applicationTagStatus) {
            this.applicationTagStatus = applicationTagStatus;
        }

        @Override
        public final Builder applicationTagStatus(String applicationTagStatus) {
            this.applicationTagStatus = applicationTagStatus;
            return this;
        }

        @Override
        public final Builder applicationTagStatus(ApplicationTagStatus applicationTagStatus) {
            this.applicationTagStatus(applicationTagStatus == null ? null : applicationTagStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<ResourcesListItem.Builder> getResources() {
            List<ResourcesListItem.Builder> result = ResourcesListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourcesListItem.BuilderImpl> resources) {
            this.resources = ResourcesListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourcesListItem> resources) {
            this.resources = ResourcesListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourcesListItem ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourcesListItem.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ResourcesListItem)((ResourcesListItem.Builder)ResourcesListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public ApplicationTagResult build() {
            return new ApplicationTagResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationTagResult> {
        public Builder applicationTagStatus(String var1);

        public Builder applicationTagStatus(ApplicationTagStatus var1);

        public Builder errorMessage(String var1);

        public Builder resources(Collection<ResourcesListItem> var1);

        public Builder resources(ResourcesListItem ... var1);

        public Builder resources(Consumer<ResourcesListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

