/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncResourceResponse extends ServiceCatalogAppRegistryResponse implements
        ToCopyableBuilder<SyncResourceResponse.Builder, SyncResourceResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(SyncResourceResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(SyncResourceResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> ACTION_TAKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionTaken").getter(getter(SyncResourceResponse::actionTakenAsString))
            .setter(setter(Builder::actionTaken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTaken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            RESOURCE_ARN_FIELD, ACTION_TAKEN_FIELD));

    private final String applicationArn;

    private final String resourceArn;

    private final String actionTaken;

    private SyncResourceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.resourceArn = builder.resourceArn;
        this.actionTaken = builder.actionTaken;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) that specifies the application.
     * </p>
     * 
     * @return The Amazon resource name (ARN) that specifies the application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) that specifies the resource.
     * </p>
     * 
     * @return The Amazon resource name (ARN) that specifies the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The results of the output if an application is associated with an ARN value, which could be
     * <code>syncStarted</code> or None.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionTaken} will
     * return {@link SyncAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTakenAsString}.
     * </p>
     * 
     * @return The results of the output if an application is associated with an ARN value, which could be
     *         <code>syncStarted</code> or None.
     * @see SyncAction
     */
    public final SyncAction actionTaken() {
        return SyncAction.fromValue(actionTaken);
    }

    /**
     * <p>
     * The results of the output if an application is associated with an ARN value, which could be
     * <code>syncStarted</code> or None.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionTaken} will
     * return {@link SyncAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTakenAsString}.
     * </p>
     * 
     * @return The results of the output if an application is associated with an ARN value, which could be
     *         <code>syncStarted</code> or None.
     * @see SyncAction
     */
    public final String actionTakenAsString() {
        return actionTaken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionTakenAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncResourceResponse)) {
            return false;
        }
        SyncResourceResponse other = (SyncResourceResponse) obj;
        return Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(actionTakenAsString(), other.actionTakenAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyncResourceResponse").add("ApplicationArn", applicationArn()).add("ResourceArn", resourceArn())
                .add("ActionTaken", actionTakenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "actionTaken":
            return Optional.ofNullable(clazz.cast(actionTakenAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyncResourceResponse, T> g) {
        return obj -> g.apply((SyncResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SyncResourceResponse> {
        /**
         * <p>
         * The Amazon resource name (ARN) that specifies the application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon resource name (ARN) that specifies the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The Amazon resource name (ARN) that specifies the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon resource name (ARN) that specifies the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The results of the output if an application is associated with an ARN value, which could be
         * <code>syncStarted</code> or None.
         * </p>
         * 
         * @param actionTaken
         *        The results of the output if an application is associated with an ARN value, which could be
         *        <code>syncStarted</code> or None.
         * @see SyncAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncAction
         */
        Builder actionTaken(String actionTaken);

        /**
         * <p>
         * The results of the output if an application is associated with an ARN value, which could be
         * <code>syncStarted</code> or None.
         * </p>
         * 
         * @param actionTaken
         *        The results of the output if an application is associated with an ARN value, which could be
         *        <code>syncStarted</code> or None.
         * @see SyncAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncAction
         */
        Builder actionTaken(SyncAction actionTaken);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryResponse.BuilderImpl implements Builder {
        private String applicationArn;

        private String resourceArn;

        private String actionTaken;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncResourceResponse model) {
            super(model);
            applicationArn(model.applicationArn);
            resourceArn(model.resourceArn);
            actionTaken(model.actionTaken);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getActionTaken() {
            return actionTaken;
        }

        @Override
        public final Builder actionTaken(String actionTaken) {
            this.actionTaken = actionTaken;
            return this;
        }

        @Override
        public final Builder actionTaken(SyncAction actionTaken) {
            this.actionTaken(actionTaken == null ? null : actionTaken.toString());
            return this;
        }

        public final void setActionTaken(String actionTaken) {
            this.actionTaken = actionTaken;
        }

        @Override
        public SyncResourceResponse build() {
            return new SyncResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
