/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RequiresRecreation {
    NEVER("NEVER"),
    CONDITIONALLY("CONDITIONALLY"),
    ALWAYS("ALWAYS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RequiresRecreation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RequiresRecreation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RequiresRecreation.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RequiresRecreation> knownValues() {
        return Stream.of(RequiresRecreation.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

