/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.NotificationArnsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisionedProductPlanRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, CreateProvisionedProductPlanRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::acceptLanguage)).setter(CreateProvisionedProductPlanRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::planName)).setter(CreateProvisionedProductPlanRequest.setter(Builder::planName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanName").build()}).build();
    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::planTypeAsString)).setter(CreateProvisionedProductPlanRequest.setter(Builder::planType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanType").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::notificationArns)).setter(CreateProvisionedProductPlanRequest.setter(Builder::notificationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::pathId)).setter(CreateProvisionedProductPlanRequest.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::productId)).setter(CreateProvisionedProductPlanRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::provisionedProductName)).setter(CreateProvisionedProductPlanRequest.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::provisioningArtifactId)).setter(CreateProvisionedProductPlanRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<List<UpdateProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::provisioningParameters)).setter(CreateProvisionedProductPlanRequest.setter(Builder::provisioningParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateProvisioningParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::idempotencyToken)).setter(CreateProvisionedProductPlanRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateProvisionedProductPlanRequest.getter(CreateProvisionedProductPlanRequest::tags)).setter(CreateProvisionedProductPlanRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PLAN_NAME_FIELD, PLAN_TYPE_FIELD, NOTIFICATION_ARNS_FIELD, PATH_ID_FIELD, PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_PARAMETERS_FIELD, IDEMPOTENCY_TOKEN_FIELD, TAGS_FIELD));
    private final String acceptLanguage;
    private final String planName;
    private final String planType;
    private final List<String> notificationArns;
    private final String pathId;
    private final String productId;
    private final String provisionedProductName;
    private final String provisioningArtifactId;
    private final List<UpdateProvisioningParameter> provisioningParameters;
    private final String idempotencyToken;
    private final List<Tag> tags;

    private CreateProvisionedProductPlanRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.planName = builder.planName;
        this.planType = builder.planType;
        this.notificationArns = builder.notificationArns;
        this.pathId = builder.pathId;
        this.productId = builder.productId;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningParameters = builder.provisioningParameters;
        this.idempotencyToken = builder.idempotencyToken;
        this.tags = builder.tags;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String planName() {
        return this.planName;
    }

    public ProvisionedProductPlanType planType() {
        return ProvisionedProductPlanType.fromValue(this.planType);
    }

    public String planTypeAsString() {
        return this.planType;
    }

    public List<String> notificationArns() {
        return this.notificationArns;
    }

    public String pathId() {
        return this.pathId;
    }

    public String productId() {
        return this.productId;
    }

    public String provisionedProductName() {
        return this.provisionedProductName;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public List<UpdateProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.planName());
        hashCode = 31 * hashCode + Objects.hashCode(this.planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisionedProductPlanRequest)) {
            return false;
        }
        CreateProvisionedProductPlanRequest other = (CreateProvisionedProductPlanRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.planName(), other.planName()) && Objects.equals(this.planTypeAsString(), other.planTypeAsString()) && Objects.equals(this.notificationArns(), other.notificationArns()) && Objects.equals(this.pathId(), other.pathId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.provisioningParameters(), other.provisioningParameters()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateProvisionedProductPlanRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PlanName", (Object)this.planName()).add("PlanType", (Object)this.planTypeAsString()).add("NotificationArns", this.notificationArns()).add("PathId", (Object)this.pathId()).add("ProductId", (Object)this.productId()).add("ProvisionedProductName", (Object)this.provisionedProductName()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ProvisioningParameters", this.provisioningParameters()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "PlanName": {
                return Optional.ofNullable(clazz.cast(this.planName()));
            }
            case "PlanType": {
                return Optional.ofNullable(clazz.cast(this.planTypeAsString()));
            }
            case "NotificationArns": {
                return Optional.ofNullable(clazz.cast(this.notificationArns()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ProvisioningParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningParameters()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisionedProductPlanRequest, T> g) {
        return obj -> g.apply((CreateProvisionedProductPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String planName;
        private String planType;
        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();
        private String pathId;
        private String productId;
        private String provisionedProductName;
        private String provisioningArtifactId;
        private List<UpdateProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisionedProductPlanRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.planName(model.planName);
            this.planType(model.planType);
            this.notificationArns(model.notificationArns);
            this.pathId(model.pathId);
            this.productId(model.productId);
            this.provisionedProductName(model.provisionedProductName);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.provisioningParameters(model.provisioningParameters);
            this.idempotencyToken(model.idempotencyToken);
            this.tags(model.tags);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPlanName() {
            return this.planName;
        }

        @Override
        public final Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public final void setPlanName(String planName) {
            this.planName = planName;
        }

        public final String getPlanTypeAsString() {
            return this.planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(ProvisionedProductPlanType planType) {
            this.planType(planType.toString());
            return this;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        public final Collection<String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final Collection<UpdateProvisioningParameter.Builder> getProvisioningParameters() {
            return this.provisioningParameters != null ? (Collection)this.provisioningParameters.stream().map(UpdateProvisioningParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(UpdateProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder> ... provisioningParameters) {
            this.provisioningParameters(Stream.of(provisioningParameters).map(c -> (UpdateProvisioningParameter)((UpdateProvisioningParameter.Builder)UpdateProvisioningParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<UpdateProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProvisionedProductPlanRequest build() {
            return new CreateProvisionedProductPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisionedProductPlanRequest> {
        public Builder acceptLanguage(String var1);

        public Builder planName(String var1);

        public Builder planType(String var1);

        public Builder planType(ProvisionedProductPlanType var1);

        public Builder notificationArns(Collection<String> var1);

        public Builder notificationArns(String ... var1);

        public Builder pathId(String var1);

        public Builder productId(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder provisioningParameters(Collection<UpdateProvisioningParameter> var1);

        public Builder provisioningParameters(UpdateProvisioningParameter ... var1);

        public Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder> ... var1);

        public Builder idempotencyToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

