/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionMapCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceActionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceActionDetail> {
    private static final SdkField<ServiceActionSummary> SERVICE_ACTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ServiceActionDetail.getter(ServiceActionDetail::serviceActionSummary)).setter(ServiceActionDetail.setter(Builder::serviceActionSummary)).constructor(ServiceActionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionSummary").build()}).build();
    private static final SdkField<Map<String, String>> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ServiceActionDetail.getter(ServiceActionDetail::definitionAsStrings)).setter(ServiceActionDetail.setter(Builder::definitionWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_SUMMARY_FIELD, DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ServiceActionSummary serviceActionSummary;
    private final Map<String, String> definition;

    private ServiceActionDetail(BuilderImpl builder) {
        this.serviceActionSummary = builder.serviceActionSummary;
        this.definition = builder.definition;
    }

    public ServiceActionSummary serviceActionSummary() {
        return this.serviceActionSummary;
    }

    public Map<ServiceActionDefinitionKey, String> definition() {
        return ServiceActionDefinitionMapCopier.copyStringToEnum(this.definition);
    }

    public Map<String, String> definitionAsStrings() {
        return this.definition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceActionDetail)) {
            return false;
        }
        ServiceActionDetail other = (ServiceActionDetail)obj;
        return Objects.equals(this.serviceActionSummary(), other.serviceActionSummary()) && Objects.equals(this.definitionAsStrings(), other.definitionAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ServiceActionDetail").add("ServiceActionSummary", (Object)this.serviceActionSummary()).add("Definition", this.definitionAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceActionSummary": {
                return Optional.ofNullable(clazz.cast(this.serviceActionSummary()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definitionAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceActionDetail, T> g) {
        return obj -> g.apply((ServiceActionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceActionSummary serviceActionSummary;
        private Map<String, String> definition = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceActionDetail model) {
            this.serviceActionSummary(model.serviceActionSummary);
            this.definitionWithStrings(model.definition);
        }

        public final ServiceActionSummary.Builder getServiceActionSummary() {
            return this.serviceActionSummary != null ? this.serviceActionSummary.toBuilder() : null;
        }

        @Override
        public final Builder serviceActionSummary(ServiceActionSummary serviceActionSummary) {
            this.serviceActionSummary = serviceActionSummary;
            return this;
        }

        public final void setServiceActionSummary(ServiceActionSummary.BuilderImpl serviceActionSummary) {
            this.serviceActionSummary = serviceActionSummary != null ? serviceActionSummary.build() : null;
        }

        public final Map<String, String> getDefinitionAsStrings() {
            return this.definition;
        }

        @Override
        public final Builder definitionWithStrings(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
            return this;
        }

        @Override
        public final Builder definition(Map<ServiceActionDefinitionKey, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copyEnumToString(definition);
            return this;
        }

        public final void setDefinitionWithStrings(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
        }

        public ServiceActionDetail build() {
            return new ServiceActionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceActionDetail> {
        public Builder serviceActionSummary(ServiceActionSummary var1);

        default public Builder serviceActionSummary(Consumer<ServiceActionSummary.Builder> serviceActionSummary) {
            return this.serviceActionSummary((ServiceActionSummary)((ServiceActionSummary.Builder)ServiceActionSummary.builder().applyMutation(serviceActionSummary)).build());
        }

        public Builder definitionWithStrings(Map<String, String> var1);

        public Builder definition(Map<ServiceActionDefinitionKey, String> var1);
    }
}

