/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetail;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutput;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutputsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRecordResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeRecordResponse> {
    private static final SdkField<RecordDetail> RECORD_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecordDetail").getter(DescribeRecordResponse.getter(DescribeRecordResponse::recordDetail)).setter(DescribeRecordResponse.setter(Builder::recordDetail)).constructor(RecordDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordDetail").build()}).build();
    private static final SdkField<List<RecordOutput>> RECORD_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordOutputs").getter(DescribeRecordResponse.getter(DescribeRecordResponse::recordOutputs)).setter(DescribeRecordResponse.setter(Builder::recordOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(DescribeRecordResponse.getter(DescribeRecordResponse::nextPageToken)).setter(DescribeRecordResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_DETAIL_FIELD, RECORD_OUTPUTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRecordResponse.memberNameToFieldInitializer();
    private final RecordDetail recordDetail;
    private final List<RecordOutput> recordOutputs;
    private final String nextPageToken;

    private DescribeRecordResponse(BuilderImpl builder) {
        super(builder);
        this.recordDetail = builder.recordDetail;
        this.recordOutputs = builder.recordOutputs;
        this.nextPageToken = builder.nextPageToken;
    }

    public final RecordDetail recordDetail() {
        return this.recordDetail;
    }

    public final boolean hasRecordOutputs() {
        return this.recordOutputs != null && !(this.recordOutputs instanceof SdkAutoConstructList);
    }

    public final List<RecordOutput> recordOutputs() {
        return this.recordOutputs;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recordDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordOutputs() ? this.recordOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecordResponse)) {
            return false;
        }
        DescribeRecordResponse other = (DescribeRecordResponse)((Object)obj);
        return Objects.equals(this.recordDetail(), other.recordDetail()) && this.hasRecordOutputs() == other.hasRecordOutputs() && Objects.equals(this.recordOutputs(), other.recordOutputs()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRecordResponse").add("RecordDetail", (Object)this.recordDetail()).add("RecordOutputs", this.hasRecordOutputs() ? this.recordOutputs() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordDetail": {
                return Optional.ofNullable(clazz.cast(this.recordDetail()));
            }
            case "RecordOutputs": {
                return Optional.ofNullable(clazz.cast(this.recordOutputs()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecordDetail", RECORD_DETAIL_FIELD);
        map.put("RecordOutputs", RECORD_OUTPUTS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecordResponse, T> g) {
        return obj -> g.apply((DescribeRecordResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private RecordDetail recordDetail;
        private List<RecordOutput> recordOutputs = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecordResponse model) {
            super(model);
            this.recordDetail(model.recordDetail);
            this.recordOutputs(model.recordOutputs);
            this.nextPageToken(model.nextPageToken);
        }

        public final RecordDetail.Builder getRecordDetail() {
            return this.recordDetail != null ? this.recordDetail.toBuilder() : null;
        }

        public final void setRecordDetail(RecordDetail.BuilderImpl recordDetail) {
            this.recordDetail = recordDetail != null ? recordDetail.build() : null;
        }

        @Override
        public final Builder recordDetail(RecordDetail recordDetail) {
            this.recordDetail = recordDetail;
            return this;
        }

        public final List<RecordOutput.Builder> getRecordOutputs() {
            List<RecordOutput.Builder> result = RecordOutputsCopier.copyToBuilder(this.recordOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordOutputs(Collection<RecordOutput.BuilderImpl> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copyFromBuilder(recordOutputs);
        }

        @Override
        public final Builder recordOutputs(Collection<RecordOutput> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copy(recordOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordOutputs(RecordOutput ... recordOutputs) {
            this.recordOutputs(Arrays.asList(recordOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordOutputs(Consumer<RecordOutput.Builder> ... recordOutputs) {
            this.recordOutputs(Stream.of(recordOutputs).map(c -> (RecordOutput)((RecordOutput.Builder)RecordOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public DescribeRecordResponse build() {
            return new DescribeRecordResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRecordResponse> {
        public Builder recordDetail(RecordDetail var1);

        default public Builder recordDetail(Consumer<RecordDetail.Builder> recordDetail) {
            return this.recordDetail((RecordDetail)((RecordDetail.Builder)RecordDetail.builder().applyMutation(recordDetail)).build());
        }

        public Builder recordOutputs(Collection<RecordOutput> var1);

        public Builder recordOutputs(RecordOutput ... var1);

        public Builder recordOutputs(Consumer<RecordOutput.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

