/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactInfoCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisioningArtifactProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisioningArtifactProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProvisioningArtifactProperties.getter(ProvisioningArtifactProperties::name)).setter(ProvisioningArtifactProperties.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProvisioningArtifactProperties.getter(ProvisioningArtifactProperties::description)).setter(ProvisioningArtifactProperties.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Info").getter(ProvisioningArtifactProperties.getter(ProvisioningArtifactProperties::info)).setter(ProvisioningArtifactProperties.setter(Builder::info)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ProvisioningArtifactProperties.getter(ProvisioningArtifactProperties::typeAsString)).setter(ProvisioningArtifactProperties.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Boolean> DISABLE_TEMPLATE_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableTemplateValidation").getter(ProvisioningArtifactProperties.getter(ProvisioningArtifactProperties::disableTemplateValidation)).setter(ProvisioningArtifactProperties.setter(Builder::disableTemplateValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableTemplateValidation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, INFO_FIELD, TYPE_FIELD, DISABLE_TEMPLATE_VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisioningArtifactProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Map<String, String> info;
    private final String type;
    private final Boolean disableTemplateValidation;

    private ProvisioningArtifactProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.info = builder.info;
        this.type = builder.type;
        this.disableTemplateValidation = builder.disableTemplateValidation;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasInfo() {
        return this.info != null && !(this.info instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> info() {
        return this.info;
    }

    public final ProvisioningArtifactType type() {
        return ProvisioningArtifactType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Boolean disableTemplateValidation() {
        return this.disableTemplateValidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInfo() ? this.info() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableTemplateValidation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactProperties)) {
            return false;
        }
        ProvisioningArtifactProperties other = (ProvisioningArtifactProperties)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasInfo() == other.hasInfo() && Objects.equals(this.info(), other.info()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.disableTemplateValidation(), other.disableTemplateValidation());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisioningArtifactProperties").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Info", this.hasInfo() ? this.info() : null).add("Type", (Object)this.typeAsString()).add("DisableTemplateValidation", (Object)this.disableTemplateValidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Info": {
                return Optional.ofNullable(clazz.cast(this.info()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DisableTemplateValidation": {
                return Optional.ofNullable(clazz.cast(this.disableTemplateValidation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Info", INFO_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("DisableTemplateValidation", DISABLE_TEMPLATE_VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactProperties, T> g) {
        return obj -> g.apply((ProvisioningArtifactProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, String> info = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private Boolean disableTemplateValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactProperties model) {
            this.name(model.name);
            this.description(model.description);
            this.info(model.info);
            this.type(model.type);
            this.disableTemplateValidation(model.disableTemplateValidation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getInfo() {
            if (this.info instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.info;
        }

        public final void setInfo(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
        }

        @Override
        public final Builder info(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProvisioningArtifactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getDisableTemplateValidation() {
            return this.disableTemplateValidation;
        }

        public final void setDisableTemplateValidation(Boolean disableTemplateValidation) {
            this.disableTemplateValidation = disableTemplateValidation;
        }

        @Override
        public final Builder disableTemplateValidation(Boolean disableTemplateValidation) {
            this.disableTemplateValidation = disableTemplateValidation;
            return this;
        }

        public ProvisioningArtifactProperties build() {
            return new ProvisioningArtifactProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisioningArtifactProperties> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder info(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(ProvisioningArtifactType var1);

        public Builder disableTemplateValidation(Boolean var1);
    }
}

