/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.CodeStarParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceConnectionParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceConnectionParameters> {
    private static final SdkField<CodeStarParameters> CODE_STAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeStar").getter(SourceConnectionParameters.getter(SourceConnectionParameters::codeStar)).setter(SourceConnectionParameters.setter(Builder::codeStar)).constructor(CodeStarParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeStar").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_STAR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CodeStar", CODE_STAR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CodeStarParameters codeStar;

    private SourceConnectionParameters(BuilderImpl builder) {
        this.codeStar = builder.codeStar;
    }

    public final CodeStarParameters codeStar() {
        return this.codeStar;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeStar());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectionParameters)) {
            return false;
        }
        SourceConnectionParameters other = (SourceConnectionParameters)obj;
        return Objects.equals(this.codeStar(), other.codeStar());
    }

    public final String toString() {
        return ToString.builder((String)"SourceConnectionParameters").add("CodeStar", (Object)this.codeStar()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeStar": {
                return Optional.ofNullable(clazz.cast(this.codeStar()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectionParameters, T> g) {
        return obj -> g.apply((SourceConnectionParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CodeStarParameters codeStar;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectionParameters model) {
            this.codeStar(model.codeStar);
        }

        public final CodeStarParameters.Builder getCodeStar() {
            return this.codeStar != null ? this.codeStar.toBuilder() : null;
        }

        public final void setCodeStar(CodeStarParameters.BuilderImpl codeStar) {
            this.codeStar = codeStar != null ? codeStar.build() : null;
        }

        @Override
        public final Builder codeStar(CodeStarParameters codeStar) {
            this.codeStar = codeStar;
            return this;
        }

        public SourceConnectionParameters build() {
            return new SourceConnectionParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceConnectionParameters> {
        public Builder codeStar(CodeStarParameters var1);

        default public Builder codeStar(Consumer<CodeStarParameters.Builder> codeStar) {
            return this.codeStar((CodeStarParameters)((CodeStarParameters.Builder)CodeStarParameters.builder().applyMutation(codeStar)).build());
        }
    }
}

