/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ExecutionParameterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ExecutionParameter.getter(ExecutionParameter::name)).setter(ExecutionParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ExecutionParameter.getter(ExecutionParameter::type)).setter(ExecutionParameter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> DEFAULT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultValues").getter(ExecutionParameter.getter(ExecutionParameter::defaultValues)).setter(ExecutionParameter.setter(Builder::defaultValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, DEFAULT_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("DefaultValues", DEFAULT_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final List<String> defaultValues;

    private ExecutionParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValues = builder.defaultValues;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasDefaultValues() {
        return this.defaultValues != null && !(this.defaultValues instanceof SdkAutoConstructList);
    }

    public final List<String> defaultValues() {
        return this.defaultValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultValues() ? this.defaultValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionParameter)) {
            return false;
        }
        ExecutionParameter other = (ExecutionParameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && this.hasDefaultValues() == other.hasDefaultValues() && Objects.equals(this.defaultValues(), other.defaultValues());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionParameter").add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("DefaultValues", this.hasDefaultValues() ? this.defaultValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "DefaultValues": {
                return Optional.ofNullable(clazz.cast(this.defaultValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionParameter, T> g) {
        return obj -> g.apply((ExecutionParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private List<String> defaultValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionParameter model) {
            this.name(model.name);
            this.type(model.type);
            this.defaultValues(model.defaultValues);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getDefaultValues() {
            if (this.defaultValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultValues;
        }

        public final void setDefaultValues(Collection<String> defaultValues) {
            this.defaultValues = ExecutionParameterValueListCopier.copy(defaultValues);
        }

        @Override
        public final Builder defaultValues(Collection<String> defaultValues) {
            this.defaultValues = ExecutionParameterValueListCopier.copy(defaultValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValues(String ... defaultValues) {
            this.defaultValues(Arrays.asList(defaultValues));
            return this;
        }

        public ExecutionParameter build() {
            return new ExecutionParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionParameter> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder defaultValues(Collection<String> var1);

        public Builder defaultValues(String ... var1);
    }
}

