/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesForTagOptionRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListResourcesForTagOptionRequest> {
    private static final SdkField<String> TAG_OPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagOptionId").getter(ListResourcesForTagOptionRequest.getter(ListResourcesForTagOptionRequest::tagOptionId)).setter(ListResourcesForTagOptionRequest.setter(Builder::tagOptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptionId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ListResourcesForTagOptionRequest.getter(ListResourcesForTagOptionRequest::resourceType)).setter(ListResourcesForTagOptionRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(ListResourcesForTagOptionRequest.getter(ListResourcesForTagOptionRequest::pageSize)).setter(ListResourcesForTagOptionRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageToken").getter(ListResourcesForTagOptionRequest.getter(ListResourcesForTagOptionRequest::pageToken)).setter(ListResourcesForTagOptionRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_OPTION_ID_FIELD, RESOURCE_TYPE_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TagOptionId", TAG_OPTION_ID_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("PageSize", PAGE_SIZE_FIELD);
            this.put("PageToken", PAGE_TOKEN_FIELD);
        }
    });
    private final String tagOptionId;
    private final String resourceType;
    private final Integer pageSize;
    private final String pageToken;

    private ListResourcesForTagOptionRequest(BuilderImpl builder) {
        super(builder);
        this.tagOptionId = builder.tagOptionId;
        this.resourceType = builder.resourceType;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public final String tagOptionId() {
        return this.tagOptionId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForTagOptionRequest)) {
            return false;
        }
        ListResourcesForTagOptionRequest other = (ListResourcesForTagOptionRequest)((Object)obj);
        return Objects.equals(this.tagOptionId(), other.tagOptionId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesForTagOptionRequest").add("TagOptionId", (Object)this.tagOptionId()).add("ResourceType", (Object)this.resourceType()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagOptionId": {
                return Optional.ofNullable(clazz.cast(this.tagOptionId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesForTagOptionRequest, T> g) {
        return obj -> g.apply((ListResourcesForTagOptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String tagOptionId;
        private String resourceType;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForTagOptionRequest model) {
            super(model);
            this.tagOptionId(model.tagOptionId);
            this.resourceType(model.resourceType);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getTagOptionId() {
            return this.tagOptionId;
        }

        public final void setTagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
        }

        @Override
        public final Builder tagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesForTagOptionRequest build() {
            return new ListResourcesForTagOptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesForTagOptionRequest> {
        public Builder tagOptionId(String var1);

        public Builder resourceType(String var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

