/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse;

public class ListServiceActionsForProvisioningArtifactIterable
implements SdkIterable<ListServiceActionsForProvisioningArtifactResponse> {
    private final ServiceCatalogClient client;
    private final ListServiceActionsForProvisioningArtifactRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceActionsForProvisioningArtifactIterable(ServiceCatalogClient client, ListServiceActionsForProvisioningArtifactRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceActionsForProvisioningArtifactResponseFetcher();
    }

    public Iterator<ListServiceActionsForProvisioningArtifactResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListServiceActionsForProvisioningArtifactResponseFetcher
    implements SyncPageFetcher<ListServiceActionsForProvisioningArtifactResponse> {
        private ListServiceActionsForProvisioningArtifactResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceActionsForProvisioningArtifactResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListServiceActionsForProvisioningArtifactResponse nextPage(ListServiceActionsForProvisioningArtifactResponse previousPage) {
            if (previousPage == null) {
                return ListServiceActionsForProvisioningArtifactIterable.this.client.listServiceActionsForProvisioningArtifact(ListServiceActionsForProvisioningArtifactIterable.this.firstRequest);
            }
            return ListServiceActionsForProvisioningArtifactIterable.this.client.listServiceActionsForProvisioningArtifact((ListServiceActionsForProvisioningArtifactRequest)((Object)ListServiceActionsForProvisioningArtifactIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

