/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PortfolioShareType {
    IMPORTED("IMPORTED"),
    AWS_SERVICECATALOG("AWS_SERVICECATALOG"),
    AWS_ORGANIZATIONS("AWS_ORGANIZATIONS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PortfolioShareType> VALUE_MAP;
    private final String value;

    private PortfolioShareType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PortfolioShareType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PortfolioShareType> knownValues() {
        EnumSet<PortfolioShareType> knownValues = EnumSet.allOf(PortfolioShareType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PortfolioShareType.class, PortfolioShareType::toString);
    }
}

