/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateProvisionedProductResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<TerminateProvisionedProductResponse.Builder, TerminateProvisionedProductResponse> {
    private static final SdkField<RecordDetail> RECORD_DETAIL_FIELD = SdkField.<RecordDetail> builder(MarshallingType.SDK_POJO)
            .memberName("RecordDetail").getter(getter(TerminateProvisionedProductResponse::recordDetail))
            .setter(setter(Builder::recordDetail)).constructor(RecordDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_DETAIL_FIELD));

    private final RecordDetail recordDetail;

    private TerminateProvisionedProductResponse(BuilderImpl builder) {
        super(builder);
        this.recordDetail = builder.recordDetail;
    }

    /**
     * <p>
     * Information about the result of this request.
     * </p>
     * 
     * @return Information about the result of this request.
     */
    public final RecordDetail recordDetail() {
        return recordDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recordDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateProvisionedProductResponse)) {
            return false;
        }
        TerminateProvisionedProductResponse other = (TerminateProvisionedProductResponse) obj;
        return Objects.equals(recordDetail(), other.recordDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateProvisionedProductResponse").add("RecordDetail", recordDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordDetail":
            return Optional.ofNullable(clazz.cast(recordDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateProvisionedProductResponse, T> g) {
        return obj -> g.apply((TerminateProvisionedProductResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, TerminateProvisionedProductResponse> {
        /**
         * <p>
         * Information about the result of this request.
         * </p>
         * 
         * @param recordDetail
         *        Information about the result of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordDetail(RecordDetail recordDetail);

        /**
         * <p>
         * Information about the result of this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordDetail.Builder} avoiding the need
         * to create one manually via {@link RecordDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #recordDetail(RecordDetail)}.
         * 
         * @param recordDetail
         *        a consumer that will call methods on {@link RecordDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordDetail(RecordDetail)
         */
        default Builder recordDetail(Consumer<RecordDetail.Builder> recordDetail) {
            return recordDetail(RecordDetail.builder().applyMutation(recordDetail).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private RecordDetail recordDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateProvisionedProductResponse model) {
            super(model);
            recordDetail(model.recordDetail);
        }

        public final RecordDetail.Builder getRecordDetail() {
            return recordDetail != null ? recordDetail.toBuilder() : null;
        }

        public final void setRecordDetail(RecordDetail.BuilderImpl recordDetail) {
            this.recordDetail = recordDetail != null ? recordDetail.build() : null;
        }

        @Override
        public final Builder recordDetail(RecordDetail recordDetail) {
            this.recordDetail = recordDetail;
            return this;
        }

        @Override
        public TerminateProvisionedProductResponse build() {
            return new TerminateProvisionedProductResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
