/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides connection details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceConnectionParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceConnectionParameters.Builder, SourceConnectionParameters> {
    private static final SdkField<CodeStarParameters> CODE_STAR_FIELD = SdkField
            .<CodeStarParameters> builder(MarshallingType.SDK_POJO).memberName("CodeStar")
            .getter(getter(SourceConnectionParameters::codeStar)).setter(setter(Builder::codeStar))
            .constructor(CodeStarParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeStar").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_STAR_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeStarParameters codeStar;

    private SourceConnectionParameters(BuilderImpl builder) {
        this.codeStar = builder.codeStar;
    }

    /**
     * <p>
     * Provides <code>ConnectionType</code> details.
     * </p>
     * 
     * @return Provides <code>ConnectionType</code> details.
     */
    public final CodeStarParameters codeStar() {
        return codeStar;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeStar());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectionParameters)) {
            return false;
        }
        SourceConnectionParameters other = (SourceConnectionParameters) obj;
        return Objects.equals(codeStar(), other.codeStar());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceConnectionParameters").add("CodeStar", codeStar()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeStar":
            return Optional.ofNullable(clazz.cast(codeStar()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectionParameters, T> g) {
        return obj -> g.apply((SourceConnectionParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceConnectionParameters> {
        /**
         * <p>
         * Provides <code>ConnectionType</code> details.
         * </p>
         * 
         * @param codeStar
         *        Provides <code>ConnectionType</code> details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeStar(CodeStarParameters codeStar);

        /**
         * <p>
         * Provides <code>ConnectionType</code> details.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeStarParameters.Builder} avoiding the
         * need to create one manually via {@link CodeStarParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeStarParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #codeStar(CodeStarParameters)}.
         * 
         * @param codeStar
         *        a consumer that will call methods on {@link CodeStarParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeStar(CodeStarParameters)
         */
        default Builder codeStar(Consumer<CodeStarParameters.Builder> codeStar) {
            return codeStar(CodeStarParameters.builder().applyMutation(codeStar).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CodeStarParameters codeStar;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectionParameters model) {
            codeStar(model.codeStar);
        }

        public final CodeStarParameters.Builder getCodeStar() {
            return codeStar != null ? codeStar.toBuilder() : null;
        }

        public final void setCodeStar(CodeStarParameters.BuilderImpl codeStar) {
            this.codeStar = codeStar != null ? codeStar.build() : null;
        }

        @Override
        public final Builder codeStar(CodeStarParameters codeStar) {
            this.codeStar = codeStar;
            return this;
        }

        @Override
        public SourceConnectionParameters build() {
            return new SourceConnectionParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
