/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogBaseClientBuilder;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClientBuilder;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogServiceClientConfiguration;
import software.amazon.awssdk.services.servicecatalog.endpoints.ServiceCatalogEndpointProvider;

@SdkInternalApi
final class DefaultServiceCatalogClientBuilder
extends DefaultServiceCatalogBaseClientBuilder<ServiceCatalogClientBuilder, ServiceCatalogClient>
implements ServiceCatalogClientBuilder {
    DefaultServiceCatalogClientBuilder() {
    }

    @Override
    public DefaultServiceCatalogClientBuilder endpointProvider(ServiceCatalogEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ServiceCatalogClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultServiceCatalogClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ServiceCatalogServiceClientConfiguration serviceClientConfiguration = ServiceCatalogServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultServiceCatalogClient(serviceClientConfiguration, clientConfiguration);
    }
}

