/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogBaseClientBuilder;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClientBuilder;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogServiceClientConfiguration;
import software.amazon.awssdk.services.servicecatalog.endpoints.ServiceCatalogEndpointProvider;

@SdkInternalApi
final class DefaultServiceCatalogClientBuilder
extends DefaultServiceCatalogBaseClientBuilder<ServiceCatalogClientBuilder, ServiceCatalogClient>
implements ServiceCatalogClientBuilder {
    DefaultServiceCatalogClientBuilder() {
    }

    @Override
    public DefaultServiceCatalogClientBuilder endpointProvider(ServiceCatalogEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ServiceCatalogClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultServiceCatalogClientBuilder.validateClientOptions(clientConfiguration);
        ServiceCatalogServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultServiceCatalogClient client = new DefaultServiceCatalogClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ServiceCatalogServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ServiceCatalogServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

