/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Replacement {
    TRUE("TRUE"),
    FALSE("FALSE"),
    CONDITIONAL("CONDITIONAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Replacement> VALUE_MAP;
    private final String value;

    private Replacement(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Replacement fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Replacement> knownValues() {
        EnumSet<Replacement> knownValues = EnumSet.allOf(Replacement.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Replacement.class, Replacement::toString);
    }
}

