/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse;

public class SearchProvisionedProductsPublisher
implements SdkPublisher<SearchProvisionedProductsResponse> {
    private final ServiceCatalogAsyncClient client;
    private final SearchProvisionedProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchProvisionedProductsPublisher(ServiceCatalogAsyncClient client, SearchProvisionedProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchProvisionedProductsPublisher(ServiceCatalogAsyncClient client, SearchProvisionedProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchProvisionedProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchProvisionedProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchProvisionedProductsResponseFetcher
    implements AsyncPageFetcher<SearchProvisionedProductsResponse> {
        private SearchProvisionedProductsResponseFetcher() {
        }

        public boolean hasNextPage(SearchProvisionedProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<SearchProvisionedProductsResponse> nextPage(SearchProvisionedProductsResponse previousPage) {
            if (previousPage == null) {
                return SearchProvisionedProductsPublisher.this.client.searchProvisionedProducts(SearchProvisionedProductsPublisher.this.firstRequest);
            }
            return SearchProvisionedProductsPublisher.this.client.searchProvisionedProducts((SearchProvisionedProductsRequest)((Object)SearchProvisionedProductsPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

