/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.NamespacesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShareError> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(ShareError.getter(ShareError::accounts)).setter(ShareError.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ShareError.getter(ShareError::message)).setter(ShareError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(ShareError.getter(ShareError::error)).setter(ShareError.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, MESSAGE_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> accounts;
    private final String message;
    private final String error;

    private ShareError(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.message = builder.message;
        this.error = builder.error;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<String> accounts() {
        return this.accounts;
    }

    public final String message() {
        return this.message;
    }

    public final String error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareError)) {
            return false;
        }
        ShareError other = (ShareError)obj;
        return this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"ShareError").add("Accounts", this.hasAccounts() ? this.accounts() : null).add("Message", (Object)this.message()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareError, T> g) {
        return obj -> g.apply((ShareError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();
        private String message;
        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareError model) {
            this.accounts(model.accounts);
            this.message(model.message);
            this.error(model.error);
        }

        public final Collection<String> getAccounts() {
            if (this.accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = NamespacesCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = NamespacesCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public ShareError build() {
            return new ShareError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShareError> {
        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);

        public Builder message(String var1);

        public Builder error(String var1);
    }
}

