/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;

public class ListConstraintsForPortfolioIterable
implements SdkIterable<ListConstraintsForPortfolioResponse> {
    private final ServiceCatalogClient client;
    private final ListConstraintsForPortfolioRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConstraintsForPortfolioIterable(ServiceCatalogClient client, ListConstraintsForPortfolioRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConstraintsForPortfolioResponseFetcher();
    }

    public Iterator<ListConstraintsForPortfolioResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListConstraintsForPortfolioResponseFetcher
    implements SyncPageFetcher<ListConstraintsForPortfolioResponse> {
        private ListConstraintsForPortfolioResponseFetcher() {
        }

        public boolean hasNextPage(ListConstraintsForPortfolioResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListConstraintsForPortfolioResponse nextPage(ListConstraintsForPortfolioResponse previousPage) {
            if (previousPage == null) {
                return ListConstraintsForPortfolioIterable.this.client.listConstraintsForPortfolio(ListConstraintsForPortfolioIterable.this.firstRequest);
            }
            return ListConstraintsForPortfolioIterable.this.client.listConstraintsForPortfolio((ListConstraintsForPortfolioRequest)((Object)ListConstraintsForPortfolioIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

