/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConstraintsForPortfolioResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListConstraintsForPortfolioResponse> {
    private static final SdkField<List<ConstraintDetail>> CONSTRAINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConstraintDetails").getter(ListConstraintsForPortfolioResponse.getter(ListConstraintsForPortfolioResponse::constraintDetails)).setter(ListConstraintsForPortfolioResponse.setter(Builder::constraintDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConstraintDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListConstraintsForPortfolioResponse.getter(ListConstraintsForPortfolioResponse::nextPageToken)).setter(ListConstraintsForPortfolioResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINT_DETAILS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ConstraintDetail> constraintDetails;
    private final String nextPageToken;

    private ListConstraintsForPortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.constraintDetails = builder.constraintDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasConstraintDetails() {
        return this.constraintDetails != null && !(this.constraintDetails instanceof SdkAutoConstructList);
    }

    public final List<ConstraintDetail> constraintDetails() {
        return this.constraintDetails;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConstraintDetails() ? this.constraintDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConstraintsForPortfolioResponse)) {
            return false;
        }
        ListConstraintsForPortfolioResponse other = (ListConstraintsForPortfolioResponse)((Object)obj);
        return this.hasConstraintDetails() == other.hasConstraintDetails() && Objects.equals(this.constraintDetails(), other.constraintDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConstraintsForPortfolioResponse").add("ConstraintDetails", this.hasConstraintDetails() ? this.constraintDetails() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstraintDetails": {
                return Optional.ofNullable(clazz.cast(this.constraintDetails()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConstraintsForPortfolioResponse, T> g) {
        return obj -> g.apply((ListConstraintsForPortfolioResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ConstraintDetail> constraintDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConstraintsForPortfolioResponse model) {
            super(model);
            this.constraintDetails(model.constraintDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<ConstraintDetail.Builder> getConstraintDetails() {
            List<ConstraintDetail.Builder> result = ConstraintDetailsCopier.copyToBuilder(this.constraintDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConstraintDetails(Collection<ConstraintDetail.BuilderImpl> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copyFromBuilder(constraintDetails);
        }

        @Override
        @Transient
        public final Builder constraintDetails(Collection<ConstraintDetail> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copy(constraintDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder constraintDetails(ConstraintDetail ... constraintDetails) {
            this.constraintDetails(Arrays.asList(constraintDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder constraintDetails(Consumer<ConstraintDetail.Builder> ... constraintDetails) {
            this.constraintDetails(Stream.of(constraintDetails).map(c -> (ConstraintDetail)((ConstraintDetail.Builder)ConstraintDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListConstraintsForPortfolioResponse build() {
            return new ListConstraintsForPortfolioResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConstraintsForPortfolioResponse> {
        public Builder constraintDetails(Collection<ConstraintDetail> var1);

        public Builder constraintDetails(ConstraintDetail ... var1);

        public Builder constraintDetails(Consumer<ConstraintDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

