/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductStatus;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedProductAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedProductAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::name)).setter(ProvisionedProductAttribute.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::arn)).setter(ProvisionedProductAttribute.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::type)).setter(ProvisionedProductAttribute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::id)).setter(ProvisionedProductAttribute.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::statusAsString)).setter(ProvisionedProductAttribute.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::statusMessage)).setter(ProvisionedProductAttribute.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::createdTime)).setter(ProvisionedProductAttribute.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::idempotencyToken)).setter(ProvisionedProductAttribute.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<String> LAST_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRecordId").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::lastRecordId)).setter(ProvisionedProductAttribute.setter(Builder::lastRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecordId").build()}).build();
    private static final SdkField<String> LAST_PROVISIONING_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastProvisioningRecordId").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::lastProvisioningRecordId)).setter(ProvisionedProductAttribute.setter(Builder::lastProvisioningRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProvisioningRecordId").build()}).build();
    private static final SdkField<String> LAST_SUCCESSFUL_PROVISIONING_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSuccessfulProvisioningRecordId").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::lastSuccessfulProvisioningRecordId)).setter(ProvisionedProductAttribute.setter(Builder::lastSuccessfulProvisioningRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulProvisioningRecordId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::tags)).setter(ProvisionedProductAttribute.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PHYSICAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalId").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::physicalId)).setter(ProvisionedProductAttribute.setter(Builder::physicalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::productId)).setter(ProvisionedProductAttribute.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::productName)).setter(ProvisionedProductAttribute.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::provisioningArtifactId)).setter(ProvisionedProductAttribute.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactName").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::provisioningArtifactName)).setter(ProvisionedProductAttribute.setter(Builder::provisioningArtifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactName").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArn").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::userArn)).setter(ProvisionedProductAttribute.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()}).build();
    private static final SdkField<String> USER_ARN_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArnSession").getter(ProvisionedProductAttribute.getter(ProvisionedProductAttribute::userArnSession)).setter(ProvisionedProductAttribute.setter(Builder::userArnSession)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArnSession").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, TYPE_FIELD, ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_TIME_FIELD, IDEMPOTENCY_TOKEN_FIELD, LAST_RECORD_ID_FIELD, LAST_PROVISIONING_RECORD_ID_FIELD, LAST_SUCCESSFUL_PROVISIONING_RECORD_ID_FIELD, TAGS_FIELD, PHYSICAL_ID_FIELD, PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_ARTIFACT_NAME_FIELD, USER_ARN_FIELD, USER_ARN_SESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String type;
    private final String id;
    private final String status;
    private final String statusMessage;
    private final Instant createdTime;
    private final String idempotencyToken;
    private final String lastRecordId;
    private final String lastProvisioningRecordId;
    private final String lastSuccessfulProvisioningRecordId;
    private final List<Tag> tags;
    private final String physicalId;
    private final String productId;
    private final String productName;
    private final String provisioningArtifactId;
    private final String provisioningArtifactName;
    private final String userArn;
    private final String userArnSession;

    private ProvisionedProductAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.type = builder.type;
        this.id = builder.id;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdTime = builder.createdTime;
        this.idempotencyToken = builder.idempotencyToken;
        this.lastRecordId = builder.lastRecordId;
        this.lastProvisioningRecordId = builder.lastProvisioningRecordId;
        this.lastSuccessfulProvisioningRecordId = builder.lastSuccessfulProvisioningRecordId;
        this.tags = builder.tags;
        this.physicalId = builder.physicalId;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningArtifactName = builder.provisioningArtifactName;
        this.userArn = builder.userArn;
        this.userArnSession = builder.userArnSession;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String type() {
        return this.type;
    }

    public final String id() {
        return this.id;
    }

    public final ProvisionedProductStatus status() {
        return ProvisionedProductStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final String lastRecordId() {
        return this.lastRecordId;
    }

    public final String lastProvisioningRecordId() {
        return this.lastProvisioningRecordId;
    }

    public final String lastSuccessfulProvisioningRecordId() {
        return this.lastSuccessfulProvisioningRecordId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String physicalId() {
        return this.physicalId;
    }

    public final String productId() {
        return this.productId;
    }

    public final String productName() {
        return this.productName;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final String provisioningArtifactName() {
        return this.provisioningArtifactName;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final String userArnSession() {
        return this.userArnSession;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastProvisioningRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulProvisioningRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArnSession());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductAttribute)) {
            return false;
        }
        ProvisionedProductAttribute other = (ProvisionedProductAttribute)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.lastRecordId(), other.lastRecordId()) && Objects.equals(this.lastProvisioningRecordId(), other.lastProvisioningRecordId()) && Objects.equals(this.lastSuccessfulProvisioningRecordId(), other.lastSuccessfulProvisioningRecordId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.physicalId(), other.physicalId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.provisioningArtifactName(), other.provisioningArtifactName()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.userArnSession(), other.userArnSession());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedProductAttribute").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Type", (Object)this.type()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatedTime", (Object)this.createdTime()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("LastRecordId", (Object)this.lastRecordId()).add("LastProvisioningRecordId", (Object)this.lastProvisioningRecordId()).add("LastSuccessfulProvisioningRecordId", (Object)this.lastSuccessfulProvisioningRecordId()).add("Tags", this.hasTags() ? this.tags() : null).add("PhysicalId", (Object)this.physicalId()).add("ProductId", (Object)this.productId()).add("ProductName", (Object)this.productName()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ProvisioningArtifactName", (Object)this.provisioningArtifactName()).add("UserArn", (Object)this.userArn()).add("UserArnSession", (Object)this.userArnSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "LastRecordId": {
                return Optional.ofNullable(clazz.cast(this.lastRecordId()));
            }
            case "LastProvisioningRecordId": {
                return Optional.ofNullable(clazz.cast(this.lastProvisioningRecordId()));
            }
            case "LastSuccessfulProvisioningRecordId": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulProvisioningRecordId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PhysicalId": {
                return Optional.ofNullable(clazz.cast(this.physicalId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ProvisioningArtifactName": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactName()));
            }
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "UserArnSession": {
                return Optional.ofNullable(clazz.cast(this.userArnSession()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedProductAttribute, T> g) {
        return obj -> g.apply((ProvisionedProductAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String type;
        private String id;
        private String status;
        private String statusMessage;
        private Instant createdTime;
        private String idempotencyToken;
        private String lastRecordId;
        private String lastProvisioningRecordId;
        private String lastSuccessfulProvisioningRecordId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String physicalId;
        private String productId;
        private String productName;
        private String provisioningArtifactId;
        private String provisioningArtifactName;
        private String userArn;
        private String userArnSession;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductAttribute model) {
            this.name(model.name);
            this.arn(model.arn);
            this.type(model.type);
            this.id(model.id);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.createdTime(model.createdTime);
            this.idempotencyToken(model.idempotencyToken);
            this.lastRecordId(model.lastRecordId);
            this.lastProvisioningRecordId(model.lastProvisioningRecordId);
            this.lastSuccessfulProvisioningRecordId(model.lastSuccessfulProvisioningRecordId);
            this.tags(model.tags);
            this.physicalId(model.physicalId);
            this.productId(model.productId);
            this.productName(model.productName);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.provisioningArtifactName(model.provisioningArtifactName);
            this.userArn(model.userArn);
            this.userArnSession(model.userArnSession);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ProvisionedProductStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getLastRecordId() {
            return this.lastRecordId;
        }

        public final void setLastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
        }

        @Override
        @Transient
        public final Builder lastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
            return this;
        }

        public final String getLastProvisioningRecordId() {
            return this.lastProvisioningRecordId;
        }

        public final void setLastProvisioningRecordId(String lastProvisioningRecordId) {
            this.lastProvisioningRecordId = lastProvisioningRecordId;
        }

        @Override
        @Transient
        public final Builder lastProvisioningRecordId(String lastProvisioningRecordId) {
            this.lastProvisioningRecordId = lastProvisioningRecordId;
            return this;
        }

        public final String getLastSuccessfulProvisioningRecordId() {
            return this.lastSuccessfulProvisioningRecordId;
        }

        public final void setLastSuccessfulProvisioningRecordId(String lastSuccessfulProvisioningRecordId) {
            this.lastSuccessfulProvisioningRecordId = lastSuccessfulProvisioningRecordId;
        }

        @Override
        @Transient
        public final Builder lastSuccessfulProvisioningRecordId(String lastSuccessfulProvisioningRecordId) {
            this.lastSuccessfulProvisioningRecordId = lastSuccessfulProvisioningRecordId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPhysicalId() {
            return this.physicalId;
        }

        public final void setPhysicalId(String physicalId) {
            this.physicalId = physicalId;
        }

        @Override
        @Transient
        public final Builder physicalId(String physicalId) {
            this.physicalId = physicalId;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        @Transient
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        @Transient
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        @Transient
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getProvisioningArtifactName() {
            return this.provisioningArtifactName;
        }

        public final void setProvisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
        }

        @Override
        @Transient
        public final Builder provisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        @Transient
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getUserArnSession() {
            return this.userArnSession;
        }

        public final void setUserArnSession(String userArnSession) {
            this.userArnSession = userArnSession;
        }

        @Override
        @Transient
        public final Builder userArnSession(String userArnSession) {
            this.userArnSession = userArnSession;
            return this;
        }

        public ProvisionedProductAttribute build() {
            return new ProvisionedProductAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedProductAttribute> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ProvisionedProductStatus var1);

        public Builder statusMessage(String var1);

        public Builder createdTime(Instant var1);

        public Builder idempotencyToken(String var1);

        public Builder lastRecordId(String var1);

        public Builder lastProvisioningRecordId(String var1);

        public Builder lastSuccessfulProvisioningRecordId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder physicalId(String var1);

        public Builder productId(String var1);

        public Builder productName(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder provisioningArtifactName(String var1);

        public Builder userArn(String var1);

        public Builder userArnSession(String var1);
    }
}

