/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;

public class ListPortfoliosForProductPublisher
implements SdkPublisher<ListPortfoliosForProductResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListPortfoliosForProductRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPortfoliosForProductPublisher(ServiceCatalogAsyncClient client, ListPortfoliosForProductRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPortfoliosForProductPublisher(ServiceCatalogAsyncClient client, ListPortfoliosForProductRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPortfoliosForProductResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPortfoliosForProductResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPortfoliosForProductResponseFetcher
    implements AsyncPageFetcher<ListPortfoliosForProductResponse> {
        private ListPortfoliosForProductResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosForProductResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListPortfoliosForProductResponse> nextPage(ListPortfoliosForProductResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosForProductPublisher.this.client.listPortfoliosForProduct(ListPortfoliosForProductPublisher.this.firstRequest);
            }
            return ListPortfoliosForProductPublisher.this.client.listPortfoliosForProduct((ListPortfoliosForProductRequest)((Object)ListPortfoliosForProductPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

