/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPortfoliosResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListPortfoliosResponse> {
    private static final SdkField<List<PortfolioDetail>> PORTFOLIO_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortfolioDetails").getter(ListPortfoliosResponse.getter(ListPortfoliosResponse::portfolioDetails)).setter(ListPortfoliosResponse.setter(Builder::portfolioDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortfolioDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListPortfoliosResponse.getter(ListPortfoliosResponse::nextPageToken)).setter(ListPortfoliosResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_DETAILS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<PortfolioDetail> portfolioDetails;
    private final String nextPageToken;

    private ListPortfoliosResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetails = builder.portfolioDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasPortfolioDetails() {
        return this.portfolioDetails != null && !(this.portfolioDetails instanceof SdkAutoConstructList);
    }

    public final List<PortfolioDetail> portfolioDetails() {
        return this.portfolioDetails;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortfolioDetails() ? this.portfolioDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortfoliosResponse)) {
            return false;
        }
        ListPortfoliosResponse other = (ListPortfoliosResponse)((Object)obj);
        return this.hasPortfolioDetails() == other.hasPortfolioDetails() && Objects.equals(this.portfolioDetails(), other.portfolioDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPortfoliosResponse").add("PortfolioDetails", this.hasPortfolioDetails() ? this.portfolioDetails() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioDetails": {
                return Optional.ofNullable(clazz.cast(this.portfolioDetails()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPortfoliosResponse, T> g) {
        return obj -> g.apply((ListPortfoliosResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<PortfolioDetail> portfolioDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortfoliosResponse model) {
            super(model);
            this.portfolioDetails(model.portfolioDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<PortfolioDetail.Builder> getPortfolioDetails() {
            List<PortfolioDetail.Builder> result = PortfolioDetailsCopier.copyToBuilder(this.portfolioDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortfolioDetails(Collection<PortfolioDetail.BuilderImpl> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copyFromBuilder(portfolioDetails);
        }

        @Override
        public final Builder portfolioDetails(Collection<PortfolioDetail> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copy(portfolioDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(PortfolioDetail ... portfolioDetails) {
            this.portfolioDetails(Arrays.asList(portfolioDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(Consumer<PortfolioDetail.Builder> ... portfolioDetails) {
            this.portfolioDetails(Stream.of(portfolioDetails).map(c -> (PortfolioDetail)((PortfolioDetail.Builder)PortfolioDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListPortfoliosResponse build() {
            return new ListPortfoliosResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPortfoliosResponse> {
        public Builder portfolioDetails(Collection<PortfolioDetail> var1);

        public Builder portfolioDetails(PortfolioDetail ... var1);

        public Builder portfolioDetails(Consumer<PortfolioDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

