/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.StackSetAccountsCopier;
import software.amazon.awssdk.services.servicecatalog.model.StackSetRegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisioningArtifactPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisioningArtifactPreferences> {
    private static final SdkField<List<String>> STACK_SET_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackSetAccounts").getter(ProvisioningArtifactPreferences.getter(ProvisioningArtifactPreferences::stackSetAccounts)).setter(ProvisioningArtifactPreferences.setter(Builder::stackSetAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STACK_SET_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackSetRegions").getter(ProvisioningArtifactPreferences.getter(ProvisioningArtifactPreferences::stackSetRegions)).setter(ProvisioningArtifactPreferences.setter(Builder::stackSetRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_ACCOUNTS_FIELD, STACK_SET_REGIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> stackSetAccounts;
    private final List<String> stackSetRegions;

    private ProvisioningArtifactPreferences(BuilderImpl builder) {
        this.stackSetAccounts = builder.stackSetAccounts;
        this.stackSetRegions = builder.stackSetRegions;
    }

    public final boolean hasStackSetAccounts() {
        return this.stackSetAccounts != null && !(this.stackSetAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> stackSetAccounts() {
        return this.stackSetAccounts;
    }

    public final boolean hasStackSetRegions() {
        return this.stackSetRegions != null && !(this.stackSetRegions instanceof SdkAutoConstructList);
    }

    public final List<String> stackSetRegions() {
        return this.stackSetRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackSetAccounts() ? this.stackSetAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackSetRegions() ? this.stackSetRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactPreferences)) {
            return false;
        }
        ProvisioningArtifactPreferences other = (ProvisioningArtifactPreferences)obj;
        return this.hasStackSetAccounts() == other.hasStackSetAccounts() && Objects.equals(this.stackSetAccounts(), other.stackSetAccounts()) && this.hasStackSetRegions() == other.hasStackSetRegions() && Objects.equals(this.stackSetRegions(), other.stackSetRegions());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisioningArtifactPreferences").add("StackSetAccounts", this.hasStackSetAccounts() ? this.stackSetAccounts() : null).add("StackSetRegions", this.hasStackSetRegions() ? this.stackSetRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetAccounts": {
                return Optional.ofNullable(clazz.cast(this.stackSetAccounts()));
            }
            case "StackSetRegions": {
                return Optional.ofNullable(clazz.cast(this.stackSetRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactPreferences, T> g) {
        return obj -> g.apply((ProvisioningArtifactPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stackSetAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<String> stackSetRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactPreferences model) {
            this.stackSetAccounts(model.stackSetAccounts);
            this.stackSetRegions(model.stackSetRegions);
        }

        public final Collection<String> getStackSetAccounts() {
            if (this.stackSetAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackSetAccounts;
        }

        public final void setStackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
        }

        @Override
        public final Builder stackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetAccounts(String ... stackSetAccounts) {
            this.stackSetAccounts(Arrays.asList(stackSetAccounts));
            return this;
        }

        public final Collection<String> getStackSetRegions() {
            if (this.stackSetRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackSetRegions;
        }

        public final void setStackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
        }

        @Override
        public final Builder stackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetRegions(String ... stackSetRegions) {
            this.stackSetRegions(Arrays.asList(stackSetRegions));
            return this;
        }

        public ProvisioningArtifactPreferences build() {
            return new ProvisioningArtifactPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisioningArtifactPreferences> {
        public Builder stackSetAccounts(Collection<String> var1);

        public Builder stackSetAccounts(String ... var1);

        public Builder stackSetRegions(Collection<String> var1);

        public Builder stackSetRegions(String ... var1);
    }
}

