/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.ShareDetails;
import software.amazon.awssdk.services.servicecatalog.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePortfolioShareStatusResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribePortfolioShareStatusResponse> {
    private static final SdkField<String> PORTFOLIO_SHARE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortfolioShareToken").getter(DescribePortfolioShareStatusResponse.getter(DescribePortfolioShareStatusResponse::portfolioShareToken)).setter(DescribePortfolioShareStatusResponse.setter(Builder::portfolioShareToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareToken").build()}).build();
    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortfolioId").getter(DescribePortfolioShareStatusResponse.getter(DescribePortfolioShareStatusResponse::portfolioId)).setter(DescribePortfolioShareStatusResponse.setter(Builder::portfolioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()}).build();
    private static final SdkField<String> ORGANIZATION_NODE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationNodeValue").getter(DescribePortfolioShareStatusResponse.getter(DescribePortfolioShareStatusResponse::organizationNodeValue)).setter(DescribePortfolioShareStatusResponse.setter(Builder::organizationNodeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNodeValue").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribePortfolioShareStatusResponse.getter(DescribePortfolioShareStatusResponse::statusAsString)).setter(DescribePortfolioShareStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ShareDetails> SHARE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShareDetails").getter(DescribePortfolioShareStatusResponse.getter(DescribePortfolioShareStatusResponse::shareDetails)).setter(DescribePortfolioShareStatusResponse.setter(Builder::shareDetails)).constructor(ShareDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_SHARE_TOKEN_FIELD, PORTFOLIO_ID_FIELD, ORGANIZATION_NODE_VALUE_FIELD, STATUS_FIELD, SHARE_DETAILS_FIELD));
    private final String portfolioShareToken;
    private final String portfolioId;
    private final String organizationNodeValue;
    private final String status;
    private final ShareDetails shareDetails;

    private DescribePortfolioShareStatusResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioShareToken = builder.portfolioShareToken;
        this.portfolioId = builder.portfolioId;
        this.organizationNodeValue = builder.organizationNodeValue;
        this.status = builder.status;
        this.shareDetails = builder.shareDetails;
    }

    public final String portfolioShareToken() {
        return this.portfolioShareToken;
    }

    public final String portfolioId() {
        return this.portfolioId;
    }

    public final String organizationNodeValue() {
        return this.organizationNodeValue;
    }

    public final ShareStatus status() {
        return ShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ShareDetails shareDetails() {
        return this.shareDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioShareToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationNodeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioShareStatusResponse)) {
            return false;
        }
        DescribePortfolioShareStatusResponse other = (DescribePortfolioShareStatusResponse)((Object)obj);
        return Objects.equals(this.portfolioShareToken(), other.portfolioShareToken()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.organizationNodeValue(), other.organizationNodeValue()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.shareDetails(), other.shareDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePortfolioShareStatusResponse").add("PortfolioShareToken", (Object)this.portfolioShareToken()).add("PortfolioId", (Object)this.portfolioId()).add("OrganizationNodeValue", (Object)this.organizationNodeValue()).add("Status", (Object)this.statusAsString()).add("ShareDetails", (Object)this.shareDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioShareToken": {
                return Optional.ofNullable(clazz.cast(this.portfolioShareToken()));
            }
            case "PortfolioId": {
                return Optional.ofNullable(clazz.cast(this.portfolioId()));
            }
            case "OrganizationNodeValue": {
                return Optional.ofNullable(clazz.cast(this.organizationNodeValue()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ShareDetails": {
                return Optional.ofNullable(clazz.cast(this.shareDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioShareStatusResponse, T> g) {
        return obj -> g.apply((DescribePortfolioShareStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private String portfolioShareToken;
        private String portfolioId;
        private String organizationNodeValue;
        private String status;
        private ShareDetails shareDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioShareStatusResponse model) {
            super(model);
            this.portfolioShareToken(model.portfolioShareToken);
            this.portfolioId(model.portfolioId);
            this.organizationNodeValue(model.organizationNodeValue);
            this.status(model.status);
            this.shareDetails(model.shareDetails);
        }

        public final String getPortfolioShareToken() {
            return this.portfolioShareToken;
        }

        public final void setPortfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
        }

        @Override
        public final Builder portfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
            return this;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getOrganizationNodeValue() {
            return this.organizationNodeValue;
        }

        public final void setOrganizationNodeValue(String organizationNodeValue) {
            this.organizationNodeValue = organizationNodeValue;
        }

        @Override
        public final Builder organizationNodeValue(String organizationNodeValue) {
            this.organizationNodeValue = organizationNodeValue;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ShareDetails.Builder getShareDetails() {
            return this.shareDetails != null ? this.shareDetails.toBuilder() : null;
        }

        public final void setShareDetails(ShareDetails.BuilderImpl shareDetails) {
            this.shareDetails = shareDetails != null ? shareDetails.build() : null;
        }

        @Override
        public final Builder shareDetails(ShareDetails shareDetails) {
            this.shareDetails = shareDetails;
            return this;
        }

        @Override
        public DescribePortfolioShareStatusResponse build() {
            return new DescribePortfolioShareStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePortfolioShareStatusResponse> {
        public Builder portfolioShareToken(String var1);

        public Builder portfolioId(String var1);

        public Builder organizationNodeValue(String var1);

        public Builder status(String var1);

        public Builder status(ShareStatus var1);

        public Builder shareDetails(ShareDetails var1);

        default public Builder shareDetails(Consumer<ShareDetails.Builder> shareDetails) {
            return this.shareDetails((ShareDetails)((ShareDetails.Builder)ShareDetails.builder().applyMutation(shareDetails)).build());
        }
    }
}

