/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse;

public class ListPortfolioAccessIterable
implements SdkIterable<ListPortfolioAccessResponse> {
    private final ServiceCatalogClient client;
    private final ListPortfolioAccessRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPortfolioAccessIterable(ServiceCatalogClient client, ListPortfolioAccessRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPortfolioAccessResponseFetcher();
    }

    public Iterator<ListPortfolioAccessResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPortfolioAccessResponseFetcher
    implements SyncPageFetcher<ListPortfolioAccessResponse> {
        private ListPortfolioAccessResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfolioAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListPortfolioAccessResponse nextPage(ListPortfolioAccessResponse previousPage) {
            if (previousPage == null) {
                return ListPortfolioAccessIterable.this.client.listPortfolioAccess(ListPortfolioAccessIterable.this.firstRequest);
            }
            return ListPortfolioAccessIterable.this.client.listPortfolioAccess((ListPortfolioAccessRequest)((Object)ListPortfolioAccessIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

