/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProductType {
    CLOUD_FORMATION_TEMPLATE("CLOUD_FORMATION_TEMPLATE"),
    MARKETPLACE("MARKETPLACE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProductType> VALUE_MAP;
    private final String value;

    private ProductType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProductType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProductType> knownValues() {
        EnumSet<ProductType> knownValues = EnumSet.allOf(ProductType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProductType.class, ProductType::toString);
    }
}

