/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceActionExecutionParametersRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DescribeServiceActionExecutionParametersRequest> {
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductId").getter(DescribeServiceActionExecutionParametersRequest.getter(DescribeServiceActionExecutionParametersRequest::provisionedProductId)).setter(DescribeServiceActionExecutionParametersRequest.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceActionId").getter(DescribeServiceActionExecutionParametersRequest.getter(DescribeServiceActionExecutionParametersRequest::serviceActionId)).setter(DescribeServiceActionExecutionParametersRequest.setter(Builder::serviceActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(DescribeServiceActionExecutionParametersRequest.getter(DescribeServiceActionExecutionParametersRequest::acceptLanguage)).setter(DescribeServiceActionExecutionParametersRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_ID_FIELD, SERVICE_ACTION_ID_FIELD, ACCEPT_LANGUAGE_FIELD));
    private final String provisionedProductId;
    private final String serviceActionId;
    private final String acceptLanguage;

    private DescribeServiceActionExecutionParametersRequest(BuilderImpl builder) {
        super(builder);
        this.provisionedProductId = builder.provisionedProductId;
        this.serviceActionId = builder.serviceActionId;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public final String provisionedProductId() {
        return this.provisionedProductId;
    }

    public final String serviceActionId() {
        return this.serviceActionId;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceActionExecutionParametersRequest)) {
            return false;
        }
        DescribeServiceActionExecutionParametersRequest other = (DescribeServiceActionExecutionParametersRequest)((Object)obj);
        return Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.serviceActionId(), other.serviceActionId()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceActionExecutionParametersRequest").add("ProvisionedProductId", (Object)this.provisionedProductId()).add("ServiceActionId", (Object)this.serviceActionId()).add("AcceptLanguage", (Object)this.acceptLanguage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "ServiceActionId": {
                return Optional.ofNullable(clazz.cast(this.serviceActionId()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceActionExecutionParametersRequest, T> g) {
        return obj -> g.apply((DescribeServiceActionExecutionParametersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String provisionedProductId;
        private String serviceActionId;
        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceActionExecutionParametersRequest model) {
            super(model);
            this.provisionedProductId(model.provisionedProductId);
            this.serviceActionId(model.serviceActionId);
            this.acceptLanguage(model.acceptLanguage);
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        @Override
        @Transient
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final String getServiceActionId() {
            return this.serviceActionId;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        @Override
        @Transient
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        @Transient
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceActionExecutionParametersRequest build() {
            return new DescribeServiceActionExecutionParametersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceActionExecutionParametersRequest> {
        public Builder provisionedProductId(String var1);

        public Builder serviceActionId(String var1);

        public Builder acceptLanguage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

