/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.NotificationArnsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ProvisionProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(ProvisionProductRequest.getter(ProvisionProductRequest::acceptLanguage)).setter(ProvisionProductRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ProvisionProductRequest.getter(ProvisionProductRequest::productId)).setter(ProvisionProductRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(ProvisionProductRequest.getter(ProvisionProductRequest::productName)).setter(ProvisionProductRequest.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisioningArtifactId)).setter(ProvisionProductRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactName").getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisioningArtifactName)).setter(ProvisionProductRequest.setter(Builder::provisioningArtifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactName").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathId").getter(ProvisionProductRequest.getter(ProvisionProductRequest::pathId)).setter(ProvisionProductRequest.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<String> PATH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathName").getter(ProvisionProductRequest.getter(ProvisionProductRequest::pathName)).setter(ProvisionProductRequest.setter(Builder::pathName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathName").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductName").getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisionedProductName)).setter(ProvisionProductRequest.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisioningParameters").getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisioningParameters)).setter(ProvisionProductRequest.setter(Builder::provisioningParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProvisioningPreferences> PROVISIONING_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisioningPreferences").getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisioningPreferences)).setter(ProvisionProductRequest.setter(Builder::provisioningPreferences)).constructor(ProvisioningPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningPreferences").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ProvisionProductRequest.getter(ProvisionProductRequest::tags)).setter(ProvisionProductRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotificationArns").getter(ProvisionProductRequest.getter(ProvisionProductRequest::notificationArns)).setter(ProvisionProductRequest.setter(Builder::notificationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVISION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionToken").getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisionToken)).setter(ProvisionProductRequest.setter(Builder::provisionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_ARTIFACT_NAME_FIELD, PATH_ID_FIELD, PATH_NAME_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONING_PARAMETERS_FIELD, PROVISIONING_PREFERENCES_FIELD, TAGS_FIELD, NOTIFICATION_ARNS_FIELD, PROVISION_TOKEN_FIELD));
    private final String acceptLanguage;
    private final String productId;
    private final String productName;
    private final String provisioningArtifactId;
    private final String provisioningArtifactName;
    private final String pathId;
    private final String pathName;
    private final String provisionedProductName;
    private final List<ProvisioningParameter> provisioningParameters;
    private final ProvisioningPreferences provisioningPreferences;
    private final List<Tag> tags;
    private final List<String> notificationArns;
    private final String provisionToken;

    private ProvisionProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningArtifactName = builder.provisioningArtifactName;
        this.pathId = builder.pathId;
        this.pathName = builder.pathName;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningParameters = builder.provisioningParameters;
        this.provisioningPreferences = builder.provisioningPreferences;
        this.tags = builder.tags;
        this.notificationArns = builder.notificationArns;
        this.provisionToken = builder.provisionToken;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String productId() {
        return this.productId;
    }

    public final String productName() {
        return this.productName;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final String provisioningArtifactName() {
        return this.provisioningArtifactName;
    }

    public final String pathId() {
        return this.pathId;
    }

    public final String pathName() {
        return this.pathName;
    }

    public final String provisionedProductName() {
        return this.provisionedProductName;
    }

    public final boolean hasProvisioningParameters() {
        return this.provisioningParameters != null && !(this.provisioningParameters instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public final ProvisioningPreferences provisioningPreferences() {
        return this.provisioningPreferences;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasNotificationArns() {
        return this.notificationArns != null && !(this.notificationArns instanceof SdkAutoConstructList);
    }

    public final List<String> notificationArns() {
        return this.notificationArns;
    }

    public final String provisionToken() {
        return this.provisionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningParameters() ? this.provisioningParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationArns() ? this.notificationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionProductRequest)) {
            return false;
        }
        ProvisionProductRequest other = (ProvisionProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.provisioningArtifactName(), other.provisioningArtifactName()) && Objects.equals(this.pathId(), other.pathId()) && Objects.equals(this.pathName(), other.pathName()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && this.hasProvisioningParameters() == other.hasProvisioningParameters() && Objects.equals(this.provisioningParameters(), other.provisioningParameters()) && Objects.equals(this.provisioningPreferences(), other.provisioningPreferences()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasNotificationArns() == other.hasNotificationArns() && Objects.equals(this.notificationArns(), other.notificationArns()) && Objects.equals(this.provisionToken(), other.provisionToken());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionProductRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProductId", (Object)this.productId()).add("ProductName", (Object)this.productName()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ProvisioningArtifactName", (Object)this.provisioningArtifactName()).add("PathId", (Object)this.pathId()).add("PathName", (Object)this.pathName()).add("ProvisionedProductName", (Object)this.provisionedProductName()).add("ProvisioningParameters", this.hasProvisioningParameters() ? this.provisioningParameters() : null).add("ProvisioningPreferences", (Object)this.provisioningPreferences()).add("Tags", this.hasTags() ? this.tags() : null).add("NotificationArns", this.hasNotificationArns() ? this.notificationArns() : null).add("ProvisionToken", (Object)this.provisionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ProvisioningArtifactName": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactName()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "PathName": {
                return Optional.ofNullable(clazz.cast(this.pathName()));
            }
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "ProvisioningParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningParameters()));
            }
            case "ProvisioningPreferences": {
                return Optional.ofNullable(clazz.cast(this.provisioningPreferences()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NotificationArns": {
                return Optional.ofNullable(clazz.cast(this.notificationArns()));
            }
            case "ProvisionToken": {
                return Optional.ofNullable(clazz.cast(this.provisionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionProductRequest, T> g) {
        return obj -> g.apply((ProvisionProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String productName;
        private String provisioningArtifactId;
        private String provisioningArtifactName;
        private String pathId;
        private String pathName;
        private String provisionedProductName;
        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();
        private ProvisioningPreferences provisioningPreferences;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();
        private String provisionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionProductRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.productName(model.productName);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.provisioningArtifactName(model.provisioningArtifactName);
            this.pathId(model.pathId);
            this.pathName(model.pathName);
            this.provisionedProductName(model.provisionedProductName);
            this.provisioningParameters(model.provisioningParameters);
            this.provisioningPreferences(model.provisioningPreferences);
            this.tags(model.tags);
            this.notificationArns(model.notificationArns);
            this.provisionToken(model.provisionToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        @Transient
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        @Transient
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        @Transient
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        @Transient
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getProvisioningArtifactName() {
            return this.provisioningArtifactName;
        }

        public final void setProvisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
        }

        @Override
        @Transient
        public final Builder provisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        public final String getPathId() {
            return this.pathId;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        @Override
        @Transient
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final String getPathName() {
            return this.pathName;
        }

        public final void setPathName(String pathName) {
            this.pathName = pathName;
        }

        @Override
        @Transient
        public final Builder pathName(String pathName) {
            this.pathName = pathName;
            return this;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        @Override
        @Transient
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final List<ProvisioningParameter.Builder> getProvisioningParameters() {
            List<ProvisioningParameter.Builder> result = ProvisioningParametersCopier.copyToBuilder(this.provisioningParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        @Override
        @Transient
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... provisioningParameters) {
            this.provisioningParameters(Stream.of(provisioningParameters).map(c -> (ProvisioningParameter)((ProvisioningParameter.Builder)ProvisioningParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProvisioningPreferences.Builder getProvisioningPreferences() {
            return this.provisioningPreferences != null ? this.provisioningPreferences.toBuilder() : null;
        }

        public final void setProvisioningPreferences(ProvisioningPreferences.BuilderImpl provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences != null ? provisioningPreferences.build() : null;
        }

        @Override
        @Transient
        public final Builder provisioningPreferences(ProvisioningPreferences provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNotificationArns() {
            if (this.notificationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notificationArns;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        @Override
        @Transient
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final String getProvisionToken() {
            return this.provisionToken;
        }

        public final void setProvisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
        }

        @Override
        @Transient
        public final Builder provisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionProductRequest build() {
            return new ProvisionProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder productName(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder provisioningArtifactName(String var1);

        public Builder pathId(String var1);

        public Builder pathName(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisioningParameters(Collection<ProvisioningParameter> var1);

        public Builder provisioningParameters(ProvisioningParameter ... var1);

        public Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... var1);

        public Builder provisioningPreferences(ProvisioningPreferences var1);

        default public Builder provisioningPreferences(Consumer<ProvisioningPreferences.Builder> provisioningPreferences) {
            return this.provisioningPreferences((ProvisioningPreferences)((ProvisioningPreferences.Builder)ProvisioningPreferences.builder().applyMutation(provisioningPreferences)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder notificationArns(Collection<String> var1);

        public Builder notificationArns(String ... var1);

        public Builder provisionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

