/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.AllowedValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterConstraints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterConstraints> {
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedValues").getter(ParameterConstraints.getter(ParameterConstraints::allowedValues)).setter(ParameterConstraints.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALLOWED_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedPattern").getter(ParameterConstraints.getter(ParameterConstraints::allowedPattern)).setter(ParameterConstraints.setter(Builder::allowedPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPattern").build()}).build();
    private static final SdkField<String> CONSTRAINT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstraintDescription").getter(ParameterConstraints.getter(ParameterConstraints::constraintDescription)).setter(ParameterConstraints.setter(Builder::constraintDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintDescription").build()}).build();
    private static final SdkField<String> MAX_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxLength").getter(ParameterConstraints.getter(ParameterConstraints::maxLength)).setter(ParameterConstraints.setter(Builder::maxLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()}).build();
    private static final SdkField<String> MIN_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinLength").getter(ParameterConstraints.getter(ParameterConstraints::minLength)).setter(ParameterConstraints.setter(Builder::minLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinLength").build()}).build();
    private static final SdkField<String> MAX_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxValue").getter(ParameterConstraints.getter(ParameterConstraints::maxValue)).setter(ParameterConstraints.setter(Builder::maxValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()}).build();
    private static final SdkField<String> MIN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinValue").getter(ParameterConstraints.getter(ParameterConstraints::minValue)).setter(ParameterConstraints.setter(Builder::minValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD, ALLOWED_PATTERN_FIELD, CONSTRAINT_DESCRIPTION_FIELD, MAX_LENGTH_FIELD, MIN_LENGTH_FIELD, MAX_VALUE_FIELD, MIN_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedValues;
    private final String allowedPattern;
    private final String constraintDescription;
    private final String maxLength;
    private final String minLength;
    private final String maxValue;
    private final String minValue;

    private ParameterConstraints(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.allowedPattern = builder.allowedPattern;
        this.constraintDescription = builder.constraintDescription;
        this.maxLength = builder.maxLength;
        this.minLength = builder.minLength;
        this.maxValue = builder.maxValue;
        this.minValue = builder.minValue;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public final String allowedPattern() {
        return this.allowedPattern;
    }

    public final String constraintDescription() {
        return this.constraintDescription;
    }

    public final String maxLength() {
        return this.maxLength;
    }

    public final String minLength() {
        return this.minLength;
    }

    public final String maxValue() {
        return this.maxValue;
    }

    public final String minValue() {
        return this.minValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.minLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConstraints)) {
            return false;
        }
        ParameterConstraints other = (ParameterConstraints)obj;
        return this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.allowedPattern(), other.allowedPattern()) && Objects.equals(this.constraintDescription(), other.constraintDescription()) && Objects.equals(this.maxLength(), other.maxLength()) && Objects.equals(this.minLength(), other.minLength()) && Objects.equals(this.maxValue(), other.maxValue()) && Objects.equals(this.minValue(), other.minValue());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterConstraints").add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("AllowedPattern", (Object)this.allowedPattern()).add("ConstraintDescription", (Object)this.constraintDescription()).add("MaxLength", (Object)this.maxLength()).add("MinLength", (Object)this.minLength()).add("MaxValue", (Object)this.maxValue()).add("MinValue", (Object)this.minValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "AllowedPattern": {
                return Optional.ofNullable(clazz.cast(this.allowedPattern()));
            }
            case "ConstraintDescription": {
                return Optional.ofNullable(clazz.cast(this.constraintDescription()));
            }
            case "MaxLength": {
                return Optional.ofNullable(clazz.cast(this.maxLength()));
            }
            case "MinLength": {
                return Optional.ofNullable(clazz.cast(this.minLength()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterConstraints, T> g) {
        return obj -> g.apply((ParameterConstraints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String allowedPattern;
        private String constraintDescription;
        private String maxLength;
        private String minLength;
        private String maxValue;
        private String minValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConstraints model) {
            this.allowedValues(model.allowedValues);
            this.allowedPattern(model.allowedPattern);
            this.constraintDescription(model.constraintDescription);
            this.maxLength(model.maxLength);
            this.minLength(model.minLength);
            this.maxValue(model.maxValue);
            this.minValue(model.minValue);
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        @Override
        @Transient
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        @Override
        @Transient
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final String getConstraintDescription() {
            return this.constraintDescription;
        }

        public final void setConstraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
        }

        @Override
        @Transient
        public final Builder constraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
            return this;
        }

        public final String getMaxLength() {
            return this.maxLength;
        }

        public final void setMaxLength(String maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        @Transient
        public final Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final String getMinLength() {
            return this.minLength;
        }

        public final void setMinLength(String minLength) {
            this.minLength = minLength;
        }

        @Override
        @Transient
        public final Builder minLength(String minLength) {
            this.minLength = minLength;
            return this;
        }

        public final String getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        @Transient
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final String getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Override
        @Transient
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public ParameterConstraints build() {
            return new ParameterConstraints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterConstraints> {
        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder allowedPattern(String var1);

        public Builder constraintDescription(String var1);

        public Builder maxLength(String var1);

        public Builder minLength(String var1);

        public Builder maxValue(String var1);

        public Builder minValue(String var1);
    }
}

