/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessLevelFilterKey {
    ACCOUNT("Account"),
    ROLE("Role"),
    USER("User"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessLevelFilterKey> VALUE_MAP;
    private final String value;

    private AccessLevelFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessLevelFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessLevelFilterKey> knownValues() {
        EnumSet<AccessLevelFilterKey> knownValues = EnumSet.allOf(AccessLevelFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessLevelFilterKey.class, AccessLevelFilterKey::toString);
    }
}

