/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionMapCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceActionRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, CreateServiceActionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateServiceActionRequest.getter(CreateServiceActionRequest::name)).setter(CreateServiceActionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DEFINITION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefinitionType").getter(CreateServiceActionRequest.getter(CreateServiceActionRequest::definitionTypeAsString)).setter(CreateServiceActionRequest.setter(Builder::definitionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionType").build()}).build();
    private static final SdkField<Map<String, String>> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Definition").getter(CreateServiceActionRequest.getter(CreateServiceActionRequest::definitionAsStrings)).setter(CreateServiceActionRequest.setter(Builder::definitionWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateServiceActionRequest.getter(CreateServiceActionRequest::description)).setter(CreateServiceActionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(CreateServiceActionRequest.getter(CreateServiceActionRequest::acceptLanguage)).setter(CreateServiceActionRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateServiceActionRequest.getter(CreateServiceActionRequest::idempotencyToken)).setter(CreateServiceActionRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFINITION_TYPE_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD, ACCEPT_LANGUAGE_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String name;
    private final String definitionType;
    private final Map<String, String> definition;
    private final String description;
    private final String acceptLanguage;
    private final String idempotencyToken;

    private CreateServiceActionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.definitionType = builder.definitionType;
        this.definition = builder.definition;
        this.description = builder.description;
        this.acceptLanguage = builder.acceptLanguage;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String name() {
        return this.name;
    }

    public final ServiceActionDefinitionType definitionType() {
        return ServiceActionDefinitionType.fromValue(this.definitionType);
    }

    public final String definitionTypeAsString() {
        return this.definitionType;
    }

    public final Map<ServiceActionDefinitionKey, String> definition() {
        return ServiceActionDefinitionMapCopier.copyStringToEnum(this.definition);
    }

    public final boolean hasDefinition() {
        return this.definition != null && !(this.definition instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> definitionAsStrings() {
        return this.definition;
    }

    public final String description() {
        return this.description;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefinition() ? this.definitionAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceActionRequest)) {
            return false;
        }
        CreateServiceActionRequest other = (CreateServiceActionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.definitionTypeAsString(), other.definitionTypeAsString()) && this.hasDefinition() == other.hasDefinition() && Objects.equals(this.definitionAsStrings(), other.definitionAsStrings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceActionRequest").add("Name", (Object)this.name()).add("DefinitionType", (Object)this.definitionTypeAsString()).add("Definition", this.hasDefinition() ? this.definitionAsStrings() : null).add("Description", (Object)this.description()).add("AcceptLanguage", (Object)this.acceptLanguage()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DefinitionType": {
                return Optional.ofNullable(clazz.cast(this.definitionTypeAsString()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definitionAsStrings()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceActionRequest, T> g) {
        return obj -> g.apply((CreateServiceActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String name;
        private String definitionType;
        private Map<String, String> definition = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private String acceptLanguage;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceActionRequest model) {
            super(model);
            this.name(model.name);
            this.definitionType(model.definitionType);
            this.definitionWithStrings(model.definition);
            this.description(model.description);
            this.acceptLanguage(model.acceptLanguage);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefinitionType() {
            return this.definitionType;
        }

        @Override
        public final Builder definitionType(String definitionType) {
            this.definitionType = definitionType;
            return this;
        }

        @Override
        public final Builder definitionType(ServiceActionDefinitionType definitionType) {
            this.definitionType(definitionType == null ? null : definitionType.toString());
            return this;
        }

        public final void setDefinitionType(String definitionType) {
            this.definitionType = definitionType;
        }

        public final Map<String, String> getDefinition() {
            if (this.definition instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.definition;
        }

        @Override
        public final Builder definitionWithStrings(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
            return this;
        }

        @Override
        public final Builder definition(Map<ServiceActionDefinitionKey, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copyEnumToString(definition);
            return this;
        }

        public final void setDefinition(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceActionRequest build() {
            return new CreateServiceActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceActionRequest> {
        public Builder name(String var1);

        public Builder definitionType(String var1);

        public Builder definitionType(ServiceActionDefinitionType var1);

        public Builder definitionWithStrings(Map<String, String> var1);

        public Builder definition(Map<ServiceActionDefinitionKey, String> var1);

        public Builder description(String var1);

        public Builder acceptLanguage(String var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

